/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.label_verifier.verifiers;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.plugins.label_verifier.LabelVerifier;
import hudson.plugins.label_verifier.LabelVerifierDescriptor;
import hudson.plugins.label_verifier.Messages;
import hudson.remoting.Channel;
import hudson.tasks.Shell;
import java.io.IOException;
import java.util.Collections;
import org.kohsuke.stapler.DataBoundConstructor;

public class ShellScriptVerifier
extends LabelVerifier {
    public final String script;

    @DataBoundConstructor
    public ShellScriptVerifier(String script) {
        this.script = script;
    }

    @Override
    public void verify(LabelAtom label, Computer c, Channel channel, FilePath root, TaskListener listener) throws IOException, InterruptedException {
        Shell shell = new Shell(this.script);
        FilePath scriptFile = shell.createScriptFile(root);
        shell.buildCommandLine(scriptFile);
        int r = root.createLauncher(listener).launch().cmds(shell.buildCommandLine(scriptFile)).envs(Collections.singletonMap("LABEL", label.getName())).stdout(listener).pwd(root).join();
        if (r != 0) {
            throw new AbortException();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends LabelVerifierDescriptor {
        public String getDisplayName() {
            return Messages.verifiers_shell_displayName();
        }

        @Override
        public String getShortName() {
            return Messages.verifiers_shell_shortName();
        }
    }
}

