/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.label_verifier.verifiers;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.plugins.label_verifier.LabelVerifier;
import hudson.plugins.label_verifier.LabelVerifierDescriptor;
import hudson.plugins.label_verifier.Messages;
import hudson.plugins.label_verifier.util.LabelVerifierException;
import hudson.remoting.Channel;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RegexNameVerifier
extends LabelVerifier {
    private final String regexExpression;

    @DataBoundConstructor
    public RegexNameVerifier(String regexExpression) {
        this.regexExpression = regexExpression;
    }

    public String getRegexExpression() {
        return this.regexExpression;
    }

    @Override
    public void verify(LabelAtom label, Computer c, Channel channel, FilePath root, TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println();
        try {
            Pattern.compile(this.regexExpression);
        }
        catch (PatternSyntaxException ex) {
            listener.error(Messages.verifiers_regex_invalidRegexMessage(ex.getPattern()));
            return;
        }
        if (!c.getName().matches(this.regexExpression)) {
            LabelVerifierException.evaluationError(this);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends LabelVerifierDescriptor {
        public String getDisplayName() {
            return Messages.verifiers_regex_displayName();
        }

        @Override
        public String getShortName() {
            return Messages.verifiers_regex_shortName();
        }

        public FormValidation doCheckRegexExpression(@QueryParameter String regexExpression) {
            try {
                Pattern.compile(regexExpression);
            }
            catch (PatternSyntaxException exception) {
                return FormValidation.error((String)(exception.getDescription() + "\nRestriction will be ignored"));
            }
            return FormValidation.ok();
        }
    }
}

