// CHECKSTYLE:OFF

package hudson.plugins.label_verifier;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code verifiers.shell.displayName}: {@code Verify by shell
     * script}.
     * 
     * @return
     *     {@code Verify by shell script}
     */
    public static String verifiers_shell_displayName() {
        return holder.format("verifiers.shell.displayName");
    }

    /**
     * Key {@code verifiers.shell.displayName}: {@code Verify by shell
     * script}.
     * 
     * @return
     *     {@code Verify by shell script}
     */
    public static Localizable _verifiers_shell_displayName() {
        return new Localizable(holder, "verifiers.shell.displayName");
    }

    /**
     * Key {@code logic.or.displayName}: {@code Or}.
     * 
     * @return
     *     {@code Or}
     */
    public static String logic_or_displayName() {
        return holder.format("logic.or.displayName");
    }

    /**
     * Key {@code logic.or.displayName}: {@code Or}.
     * 
     * @return
     *     {@code Or}
     */
    public static Localizable _logic_or_displayName() {
        return new Localizable(holder, "logic.or.displayName");
    }

    /**
     * Key {@code logic.not.displayName}: {@code Not}.
     * 
     * @return
     *     {@code Not}
     */
    public static String logic_not_displayName() {
        return holder.format("logic.not.displayName");
    }

    /**
     * Key {@code logic.not.displayName}: {@code Not}.
     * 
     * @return
     *     {@code Not}
     */
    public static Localizable _logic_not_displayName() {
        return new Localizable(holder, "logic.not.displayName");
    }

    /**
     * Key {@code verifiers.shell.failMessage}: {@code The script failed.
     * Label ''{0}'' is refused.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The script failed. Label ''{0}'' is refused.}
     */
    public static String verifiers_shell_failMessage(Object arg0) {
        return holder.format("verifiers.shell.failMessage", arg0);
    }

    /**
     * Key {@code verifiers.shell.failMessage}: {@code The script failed.
     * Label ''{0}'' is refused.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The script failed. Label ''{0}'' is refused.}
     */
    public static Localizable _verifiers_shell_failMessage(Object arg0) {
        return new Localizable(holder, "verifiers.shell.failMessage", arg0);
    }

    /**
     * Key {@code logic.always.displayName}: {@code Always fail}.
     * 
     * @return
     *     {@code Always fail}
     */
    public static String logic_always_displayName() {
        return holder.format("logic.always.displayName");
    }

    /**
     * Key {@code logic.always.displayName}: {@code Always fail}.
     * 
     * @return
     *     {@code Always fail}
     */
    public static Localizable _logic_always_displayName() {
        return new Localizable(holder, "logic.always.displayName");
    }

    /**
     * Key {@code shared.evalFailureMessage}: {@code Evaluation of ''{0}''
     * expression returned false}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Evaluation of ''{0}'' expression returned false}
     */
    public static String shared_evalFailureMessage(Object arg0) {
        return holder.format("shared.evalFailureMessage", arg0);
    }

    /**
     * Key {@code shared.evalFailureMessage}: {@code Evaluation of ''{0}''
     * expression returned false}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Evaluation of ''{0}'' expression returned false}
     */
    public static Localizable _shared_evalFailureMessage(Object arg0) {
        return new Localizable(holder, "shared.evalFailureMessage", arg0);
    }

    /**
     * Key {@code verifiers.regex.displayName}: {@code Verify computer name
     * by regular expression}.
     * 
     * @return
     *     {@code Verify computer name by regular expression}
     */
    public static String verifiers_regex_displayName() {
        return holder.format("verifiers.regex.displayName");
    }

    /**
     * Key {@code verifiers.regex.displayName}: {@code Verify computer name
     * by regular expression}.
     * 
     * @return
     *     {@code Verify computer name by regular expression}
     */
    public static Localizable _verifiers_regex_displayName() {
        return new Localizable(holder, "verifiers.regex.displayName");
    }

    /**
     * Key {@code verifiers.regex.shortName}: {@code Regex}.
     * 
     * @return
     *     {@code Regex}
     */
    public static String verifiers_regex_shortName() {
        return holder.format("verifiers.regex.shortName");
    }

    /**
     * Key {@code verifiers.regex.shortName}: {@code Regex}.
     * 
     * @return
     *     {@code Regex}
     */
    public static Localizable _verifiers_regex_shortName() {
        return new Localizable(holder, "verifiers.regex.shortName");
    }

    /**
     * Key {@code shared.validatingLabelMessage}: {@code Validating the label
     * ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Validating the label ''{0}''}
     */
    public static String shared_validatingLabelMessage(Object arg0) {
        return holder.format("shared.validatingLabelMessage", arg0);
    }

    /**
     * Key {@code shared.validatingLabelMessage}: {@code Validating the label
     * ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Validating the label ''{0}''}
     */
    public static Localizable _shared_validatingLabelMessage(Object arg0) {
        return new Localizable(holder, "shared.validatingLabelMessage", arg0);
    }

    /**
     * Key {@code logic.and.displayName}: {@code And}.
     * 
     * @return
     *     {@code And}
     */
    public static String logic_and_displayName() {
        return holder.format("logic.and.displayName");
    }

    /**
     * Key {@code logic.and.displayName}: {@code And}.
     * 
     * @return
     *     {@code And}
     */
    public static Localizable _logic_and_displayName() {
        return new Localizable(holder, "logic.and.displayName");
    }

    /**
     * Key {@code verifiers.shell.shortName}: {@code Shell script}.
     * 
     * @return
     *     {@code Shell script}
     */
    public static String verifiers_shell_shortName() {
        return holder.format("verifiers.shell.shortName");
    }

    /**
     * Key {@code verifiers.shell.shortName}: {@code Shell script}.
     * 
     * @return
     *     {@code Shell script}
     */
    public static Localizable _verifiers_shell_shortName() {
        return new Localizable(holder, "verifiers.shell.shortName");
    }

    /**
     * Key {@code logic.never.displayName}: {@code Never fail}.
     * 
     * @return
     *     {@code Never fail}
     */
    public static String logic_never_displayName() {
        return holder.format("logic.never.displayName");
    }

    /**
     * Key {@code logic.never.displayName}: {@code Never fail}.
     * 
     * @return
     *     {@code Never fail}
     */
    public static Localizable _logic_never_displayName() {
        return new Localizable(holder, "logic.never.displayName");
    }

    /**
     * Key {@code LabelAtomPropertyImpl.displayName}: {@code Verify This
     * Label}.
     * 
     * @return
     *     {@code Verify This Label}
     */
    public static String LabelAtomPropertyImpl_displayName() {
        return holder.format("LabelAtomPropertyImpl.displayName");
    }

    /**
     * Key {@code LabelAtomPropertyImpl.displayName}: {@code Verify This
     * Label}.
     * 
     * @return
     *     {@code Verify This Label}
     */
    public static Localizable _LabelAtomPropertyImpl_displayName() {
        return new Localizable(holder, "LabelAtomPropertyImpl.displayName");
    }

    /**
     * Key {@code verifiers.regex.invalidRegexMessage}: {@code Regular
     * expression for label ''{0}'' is invalid. Restriction will be skipped}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Regular expression for label ''{0}'' is invalid. Restriction
     *     will be skipped}
     */
    public static String verifiers_regex_invalidRegexMessage(Object arg0) {
        return holder.format("verifiers.regex.invalidRegexMessage", arg0);
    }

    /**
     * Key {@code verifiers.regex.invalidRegexMessage}: {@code Regular
     * expression for label ''{0}'' is invalid. Restriction will be skipped}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Regular expression for label ''{0}'' is invalid. Restriction
     *     will be skipped}
     */
    public static Localizable _verifiers_regex_invalidRegexMessage(Object arg0) {
        return new Localizable(holder, "verifiers.regex.invalidRegexMessage", arg0);
    }

}
