/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import hudson.security.SecurityRealm;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.KeycloakAuthentication;
import org.jenkinsci.plugins.KeycloakSecurityRealm;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.representations.AccessTokenResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class RefreshFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(RefreshFilter.class.getName());
    private transient boolean initCalled = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.initCalled = true;
    }

    private boolean skipUrl(HttpServletRequest paramRequest) {
        boolean result = false;
        String pathInfo = paramRequest.getPathInfo();
        LOGGER.log(Level.FINEST, "Path" + pathInfo);
        if (pathInfo != null) {
            result = pathInfo.endsWith("/logout") || pathInfo.endsWith("securityRealm/finishLogin");
        }
        return result;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        LOGGER.log(Level.FINER, "KeycloakFilter entered");
        Jenkins j = Jenkins.get();
        SecurityRealm sr = j.getSecurityRealm();
        if (sr != null && sr instanceof KeycloakSecurityRealm) {
            boolean tokeninvalid;
            KeycloakSecurityRealm ksr = (KeycloakSecurityRealm)sr;
            LOGGER.log(Level.FINER, "KeycloakSecurityRealm found");
            boolean checkTokenValidity = ksr.checkKeycloakOnEachRequest();
            HttpServletRequest httpRequest = (HttpServletRequest)req;
            HttpSession session = httpRequest.getSession();
            Boolean authRequestedAttribute = (Boolean)session.getAttribute("AUTH_REQUESTED");
            boolean authenticationRequested = authRequestedAttribute == null ? false : authRequestedAttribute;
            boolean skipUrl = this.skipUrl(httpRequest);
            LOGGER.log(Level.FINEST, "RequestPath" + httpRequest.getPathInfo() + " skipUrl" + skipUrl + " AuthenticationRequested" + authenticationRequested + " CheckRequest" + checkTokenValidity);
            if (checkTokenValidity && !skipUrl && authenticationRequested && (tokeninvalid = this.checkTokenValidity(res, ksr))) {
                return;
            }
            chain.doFilter(req, res);
        }
    }

    private boolean checkTokenValidity(ServletResponse res, KeycloakSecurityRealm ksr) throws IOException {
        Authentication auth;
        boolean tokeninvalid = false;
        LOGGER.log(Level.FINE, "KeycloakFilter is active");
        KeycloakDeployment kd = ksr.getKeycloakDeployment();
        SecurityContext sc = SecurityContextHolder.getContext();
        if (sc != null && (auth = sc.getAuthentication()) instanceof KeycloakAuthentication) {
            KeycloakAuthentication ka = (KeycloakAuthentication)auth;
            if (ka.isRefreshExpired()) {
                LOGGER.log(Level.FINE, "Keycloak refresh token is expired. Refresh token expiry " + ka.getAccessTokenResponse().getRefreshExpiresIn() + " seconds. Last refresh " + String.valueOf(ka.getLastRefresh()) + ". Current Time " + String.valueOf(new Date()));
                tokeninvalid = true;
                this.redirectToJenkinsLogoutUrl(res);
            }
            try {
                boolean respectAccessTokenTimeout = ksr.respectAccessTokenTimeout();
                Calendar secondsCheck = Calendar.getInstance();
                secondsCheck.add(13, -1);
                boolean newRefresh = secondsCheck.after(ka.getLastRefreshDateAsCalendar());
                boolean accessTokenExpired = ka.isAccessExpired();
                if (respectAccessTokenTimeout && accessTokenExpired || !respectAccessTokenTimeout && newRefresh) {
                    LOGGER.log(Level.FINE, "KeycloakFilter refresh token. Respect access token timeout: " + respectAccessTokenTimeout + ". Access token expired " + accessTokenExpired + ". Renew after 1 second:" + newRefresh);
                    AccessTokenResponse atr = ServerRequest.invokeRefresh((KeycloakDeployment)kd, (String)ka.getRefreshToken());
                    ka.setAccessTokenResponse(atr);
                }
            }
            catch (ServerRequest.HttpFailure e) {
                LOGGER.log(Level.INFO, "Refresh Token failed, message is: " + e.getMessage() + ", error is:" + e.getError() + ", statuscode is:" + e.getStatus());
                tokeninvalid = true;
                this.redirectToJenkinsLogoutUrl(res);
            }
        }
        return tokeninvalid;
    }

    private void redirectToJenkinsLogoutUrl(ServletResponse res) throws IOException {
        res.reset();
        Jenkins j = Jenkins.get();
        HttpServletResponse httpRes = (HttpServletResponse)res;
        LOGGER.log(Level.INFO, "KeycloakFilter logout requested");
        String rootURL = j.getRootUrl();
        if (rootURL == null) {
            rootURL = "";
        }
        String redirectURL = rootURL + "logout";
        LOGGER.log(Level.INFO, "Redirect to " + redirectURL);
        httpRes.sendRedirect(redirectURL);
    }

    public void destroy() {
    }

    public boolean isInitCalled() {
        return this.initCalled;
    }
}

