/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.SecurityRealm;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import hudson.util.PluginServletFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.cert.X509Certificate;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.security.SecurityListener;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.KeycloakAuthentication;
import org.jenkinsci.plugins.KeycloakAvatarProperty;
import org.jenkinsci.plugins.KeycloakUserDetails;
import org.jenkinsci.plugins.RefreshFilter;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.rotation.AdapterTokenVerifier;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.TokenUtil;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class KeycloakSecurityRealm
extends SecurityRealm {
    private static final String JENKINS_LOGIN_URL = "securityRealm/commenceLogin";
    public static final String JENKINS_FINISH_LOGIN_URL = "securityRealm/finishLogin";
    public static final String AUTH_REQUESTED = "AUTH_REQUESTED";
    private static final Logger LOGGER = Logger.getLogger(KeycloakSecurityRealm.class.getName());
    private static final String REFERER_ATTRIBUTE = KeycloakSecurityRealm.class.getName() + ".referer";
    private transient KeycloakDeployment keycloakDeployment;
    private transient RefreshFilter filter;
    private String keycloakJson = "";
    private String keycloakIdp = "";
    private boolean keycloakValidate = false;
    private boolean keycloakRespectAccessTokenTimeout = true;

    @DataBoundConstructor
    public KeycloakSecurityRealm(String keycloakIdp, String keycloakJson, boolean keycloakValidate, boolean keycloakRespectAccessTokenTimeout) throws IOException {
        if (StringUtils.isEmpty((String)keycloakJson)) {
            throw new IllegalArgumentException("Keycloak JSON is a mandatory item.");
        }
        this.setKeycloakIdp(keycloakIdp);
        this.setKeycloakJson(keycloakJson);
        this.setKeycloakValidate(keycloakValidate);
        this.setKeycloakRespectAccessTokenTimeout(keycloakRespectAccessTokenTimeout);
        this.createFilter();
    }

    protected KeycloakSecurityRealm() {
        this.createFilter();
    }

    synchronized void createFilter() {
        if (this.filter == null || !this.filter.isInitCalled()) {
            try {
                LOGGER.log(Level.INFO, "Create Filter");
                this.filter = new RefreshFilter();
                PluginServletFilter.addFilter((Filter)this.filter);
            }
            catch (ServletException e) {
                LOGGER.log(Level.SEVERE, "createFilter", e);
            }
        }
    }

    public HttpResponse doCommenceLogin(StaplerRequest request, StaplerResponse response, @Header(value="Referer") String referer) throws IOException {
        request.getSession().setAttribute(REFERER_ATTRIBUTE, (Object)referer);
        String scopeParam = TokenUtil.attachOIDCScope(null);
        String redirect = this.redirectUrl(request);
        String state = UUID.randomUUID().toString();
        KeycloakUriBuilder builder = this.getKeycloakDeployment().getAuthUrl().clone().queryParam("client_id", new Object[]{this.getKeycloakDeployment().getResourceName()}).queryParam("redirect_uri", new Object[]{redirect}).queryParam("state", new Object[]{state}).queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{scopeParam});
        String keycloakIdp = this.getKeycloakIdp();
        if (!"".equals(keycloakIdp) && keycloakIdp != null) {
            builder.queryParam("kc_idp_hint", new Object[]{keycloakIdp});
        }
        String authUrl = builder.build(new Object[0]).toString();
        request.getSession().setAttribute(AUTH_REQUESTED, (Object)Boolean.TRUE);
        request.getSession().setAttribute("state", (Object)state);
        this.createFilter();
        return new HttpRedirect(authUrl);
    }

    private String redirectUrl(StaplerRequest request) {
        String refererURL = request.getReferer();
        String requestURL = request.getRequestURL().toString();
        if (refererURL != null && requestURL != null && refererURL.startsWith("https:") && requestURL.startsWith("http:")) {
            requestURL = requestURL.replace("http:", "https:");
        }
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromUri((String)requestURL).replacePath(request.getContextPath()).replaceQuery(null).path(JENKINS_FINISH_LOGIN_URL);
        String redirect = builder.toTemplate();
        return redirect;
    }

    private KeycloakDeployment resolveDeployment(KeycloakDeployment baseDeployment, HttpServletRequest request) {
        ServletFacade facade = new ServletFacade(request);
        return new AdapterDeploymentContext(baseDeployment).resolveDeployment((HttpFacade)facade);
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="We want to catch all exceptions")
    public HttpResponse doFinishLogin(StaplerRequest request) throws IOException {
        String referer;
        block11: {
            String redirect = this.redirectUrl(request);
            try {
                LOGGER.log(Level.FINE, "Code" + request.getParameter("code"));
                LOGGER.log(Level.FINE, "Redirect" + redirect);
                KeycloakDeployment resolvedDeployment = this.resolveDeployment(this.getKeycloakDeployment(), (HttpServletRequest)request);
                LOGGER.log(Level.FINE, "TokenURL" + resolvedDeployment.getTokenUrl());
                this.checkState(request.getParameter("state"), request.getSession().getAttribute("state"));
                AccessTokenResponse tokenResponse = ServerRequest.invokeAccessCodeToToken((KeycloakDeployment)resolvedDeployment, (String)request.getParameter("code"), (String)redirect, null);
                String tokenString = tokenResponse.getToken();
                String idTokenString = tokenResponse.getIdToken();
                String refreshToken = tokenResponse.getRefreshToken();
                AccessToken token = AdapterTokenVerifier.verifyToken((String)tokenString, (KeycloakDeployment)resolvedDeployment);
                if (idTokenString != null) {
                    JWSInput input = new JWSInput(idTokenString);
                    IDToken idToken = (IDToken)input.readJsonContent(IDToken.class);
                    String resourceName = resolvedDeployment.getResourceName();
                    KeycloakAuthentication auth = new KeycloakAuthentication(idToken, token, refreshToken, tokenResponse, resourceName);
                    SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
                    User currentUser = User.current();
                    if (currentUser != null) {
                        String avatarUrl;
                        currentUser.setFullName(idToken.getPreferredUsername());
                        if (!((Mailer.UserProperty)currentUser.getProperty(Mailer.UserProperty.class)).hasExplicitlyConfiguredAddress()) {
                            currentUser.addProperty((UserProperty)new Mailer.UserProperty(idToken.getEmail()));
                        }
                        if ((avatarUrl = idToken.getPicture()) != null) {
                            LOGGER.finest("Avatar url is: " + avatarUrl);
                            KeycloakAvatarProperty.AvatarImage avatarImage = new KeycloakAvatarProperty.AvatarImage(avatarUrl);
                            KeycloakAvatarProperty keycloakAvatarProperty = new KeycloakAvatarProperty(avatarImage);
                            currentUser.addProperty((UserProperty)keycloakAvatarProperty);
                        }
                        KeycloakUserDetails userDetails = new KeycloakUserDetails(idToken.getPreferredUsername(), auth.getAuthorities());
                        SecurityListener.fireAuthenticated2((UserDetails)userDetails);
                    }
                }
            }
            catch (Exception e) {
                Throwable cause;
                ServerRequest.HttpFailure hf = null;
                LOGGER.log(Level.SEVERE, "Authentication Exception ", e);
                if (e instanceof ServerRequest.HttpFailure) {
                    hf = (ServerRequest.HttpFailure)e;
                }
                if ((cause = e.getCause()) != null) {
                    LOGGER.log(Level.SEVERE, "Original exception", cause);
                    if (cause instanceof ServerRequest.HttpFailure) {
                        hf = (ServerRequest.HttpFailure)cause;
                    }
                }
                if (hf == null) break block11;
                LOGGER.log(Level.SEVERE, "Failure Message" + ((ServerRequest.HttpFailure)e).getError());
                LOGGER.log(Level.SEVERE, "Failure HTTP Status" + ((ServerRequest.HttpFailure)e).getStatus());
            }
        }
        if (request.getSession(false) != null) {
            request.changeSessionId();
        }
        if ((referer = (String)request.getSession().getAttribute(REFERER_ATTRIBUTE)) != null) {
            LOGGER.log(Level.FINEST, "Redirecting to " + referer);
            return HttpResponses.redirectTo((String)referer);
        }
        return HttpResponses.redirectToContextRoot();
    }

    private void checkState(String queryState, Object sessionStateObj) {
        if (StringUtils.isEmpty((String)queryState) || sessionStateObj == null) {
            LOGGER.log(Level.WARNING, "Cannot validate incoming authentication attempt due to state not being found. State from query: " + queryState + " State from session: " + String.valueOf(sessionStateObj));
            throw new AuthenticationServiceException("Could not validate state token during authentication.");
        }
        String sessionState = sessionStateObj.toString();
        if (!StringUtils.equals((String)queryState, (String)sessionState)) {
            LOGGER.log(Level.WARNING, "State session value (" + sessionState + ") did NOT match parameter value (" + queryState + ")");
            throw new AuthenticationServiceException("State values did not match");
        }
        LOGGER.log(Level.FINE, "State cookie matches parameter value.");
    }

    public boolean allowsSignup() {
        return false;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        SecurityRealm.SecurityComponents sc = new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof KeycloakAuthentication) {
                    return authentication;
                }
                throw new BadCredentialsException("Unexpected authentication type: " + String.valueOf(authentication));
            }
        });
        return sc;
    }

    public String getLoginUrl() {
        return JENKINS_LOGIN_URL;
    }

    public void doLogout(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof KeycloakAuthentication) {
            KeycloakAuthentication keycloakAuthentication = (KeycloakAuthentication)authentication;
            try {
                ServerRequest.invokeLogout((KeycloakDeployment)this.getKeycloakDeployment(), (String)keycloakAuthentication.getRefreshToken());
            }
            catch (ServerRequest.HttpFailure e) {
                LOGGER.log(Level.SEVERE, "Logout Exception ", e);
            }
        }
        req.getSession().setAttribute(AUTH_REQUESTED, (Object)Boolean.FALSE);
        super.doLogout(req, rsp);
    }

    public String getKeycloakJson() {
        return this.keycloakJson;
    }

    public void setKeycloakJson(String keycloakJson) {
        this.keycloakJson = keycloakJson;
    }

    public boolean isKeycloakValidate() {
        return this.keycloakValidate;
    }

    public void setKeycloakValidate(boolean keycloakValidate) {
        this.keycloakValidate = keycloakValidate;
    }

    public boolean isKeycloakRespectAccessTokenTimeout() {
        return this.keycloakRespectAccessTokenTimeout;
    }

    public void setKeycloakRespectAccessTokenTimeout(boolean keycloakRespectAccessTokenTimeout) {
        this.keycloakRespectAccessTokenTimeout = keycloakRespectAccessTokenTimeout;
    }

    public String getKeycloakIdp() {
        return this.keycloakIdp;
    }

    public void setKeycloakIdp(String keycloakIdp) {
        this.keycloakIdp = keycloakIdp;
    }

    public boolean checkKeycloakOnEachRequest() {
        return this.isKeycloakValidate();
    }

    public boolean respectAccessTokenTimeout() {
        return this.isKeycloakRespectAccessTokenTimeout();
    }

    public synchronized KeycloakDeployment getKeycloakDeployment() throws IOException {
        if (this.keycloakDeployment == null || this.keycloakDeployment.getClient() == null) {
            AdapterConfig adapterConfig = (AdapterConfig)JsonSerialization.readValue((String)this.getKeycloakJson(), AdapterConfig.class);
            this.keycloakDeployment = KeycloakDeploymentBuilder.build((AdapterConfig)adapterConfig);
        }
        return this.keycloakDeployment;
    }

    public static class ServletFacade
    implements OIDCHttpFacade {
        private final HttpServletRequest servletRequest;

        private ServletFacade(HttpServletRequest servletRequest) {
            this.servletRequest = servletRequest;
        }

        public KeycloakSecurityContext getSecurityContext() {
            throw new IllegalStateException("Not yet implemented");
        }

        public HttpFacade.Request getRequest() {
            return new HttpFacade.Request(){

                public String getFirstParam(String param) {
                    return servletRequest.getParameter(param);
                }

                public String getMethod() {
                    return servletRequest.getMethod();
                }

                public String getURI() {
                    return servletRequest.getRequestURL().toString();
                }

                public String getRelativePath() {
                    return servletRequest.getServletPath();
                }

                public boolean isSecure() {
                    return servletRequest.isSecure();
                }

                public String getQueryParamValue(String param) {
                    return servletRequest.getParameter(param);
                }

                public HttpFacade.Cookie getCookie(String cookieName) {
                    return null;
                }

                public String getHeader(String name) {
                    return servletRequest.getHeader(name);
                }

                public List<String> getHeaders(String name) {
                    return null;
                }

                public InputStream getInputStream() {
                    try {
                        return servletRequest.getInputStream();
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }

                public String getRemoteAddr() {
                    return servletRequest.getRemoteAddr();
                }

                public void setError(AuthenticationError error) {
                    servletRequest.setAttribute(AuthenticationError.class.getName(), (Object)error);
                }

                public void setError(LogoutError error) {
                    servletRequest.setAttribute(LogoutError.class.getName(), (Object)error);
                }

                public InputStream getInputStream(boolean buffered) {
                    try {
                        return servletRequest.getInputStream();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }

        public HttpFacade.Response getResponse() {
            throw new IllegalStateException("Not yet implemented");
        }

        public X509Certificate[] getCertificateChain() {
            throw new IllegalStateException("Not yet implemented");
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getHelpFile() {
            return "/plugin/keycloak/help/help-security-realm.html";
        }

        @NonNull
        public String getDisplayName() {
            return "Keycloak Authentication Plugin";
        }

        public FormValidation doCheckKeycloakJson(@QueryParameter String value) throws ServletException {
            try {
                if (!StringUtils.isNotEmpty((String)value)) {
                    return FormValidation.error((String)"Keycloak JSON is required.");
                }
                JsonSerialization.readValue((String)value, AdapterConfig.class);
            }
            catch (IOException ex) {
                return FormValidation.error((String)"Issue parsing keycloak adapter json. JSON does not appear valid.");
            }
            return FormValidation.ok();
        }

        public SecurityRealm newInstance(StaplerRequest request, JSONObject formData) throws Descriptor.FormException {
            JSONObject keycloakJson = formData.getJSONObject("keycloak").getJSONObject("keycloakJson");
            if (keycloakJson.isNullObject() || keycloakJson.isEmpty()) {
                throw new Descriptor.FormException("Keycloak JSON is required.", "keycloakJson");
            }
            return (SecurityRealm)super.newInstance(request, formData);
        }
    }
}

