/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import jenkins.security.csp.AvatarContributor;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;

public class KeycloakAvatarProperty
extends UserProperty {
    private final AvatarImage avatarImage;

    public KeycloakAvatarProperty(AvatarImage avatarImage) {
        this.avatarImage = avatarImage;
    }

    public String getAvatarUrl() {
        if (this.isHasAvatar()) {
            return this.getAvatarImageUrl();
        }
        return null;
    }

    private String getAvatarImageUrl() {
        return this.avatarImage.url;
    }

    public boolean isHasAvatar() {
        return this.avatarImage != null && this.avatarImage.isValid();
    }

    public String getDisplayName() {
        return "Keycloak Avatar";
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "keycloak-avatar";
    }

    @SuppressRestrictedWarnings(value={AvatarContributor.class})
    public static class AvatarImage {
        private final String url;

        public AvatarImage(String url) {
            this.url = url;
            AvatarContributor.allow((String)url);
        }

        public boolean isValid() {
            return this.url != null;
        }

        private Object readResolve() {
            AvatarContributor.allow((String)this.url);
            return this;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends UserPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Keycloak Avatar";
        }

        public boolean isEnabled() {
            return false;
        }

        public UserProperty newInstance(User user) {
            return new KeycloakAvatarProperty(null);
        }
    }
}

