/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.junitrealtimetestreporter;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.AbortException;
import hudson.Main;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.junitrealtimetestreporter.TestProgress;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.StaplerProxy;

public abstract class AbstractRealtimeTestResultAction
extends AbstractTestResultAction<AbstractRealtimeTestResultAction>
implements StaplerProxy {
    private static final Logger LOGGER = Logger.getLogger(AbstractRealtimeTestResultAction.class.getName());
    private int previousResultTestsCount = -1;
    private float previousResultTestsTime = -1.0f;
    protected TestResult result;
    protected TestProgress progress;
    private transient long updated;
    public static final int NUMBER_OF_BUILDS_TO_SEARCH = 20;
    public static final List<Result> RESULTS_OF_BUILDS_TO_CONSIDER = Collections.unmodifiableList(Arrays.asList(Result.SUCCESS, Result.UNSTABLE));

    protected AbstractRealtimeTestResultAction() {
    }

    protected abstract TestResult parse() throws IOException, InterruptedException;

    protected abstract TestResult findPreviousTestResult() throws IOException, InterruptedException;

    public TestResult getResult() {
        long threshold = this.getParseInterval();
        if (this.updated > System.currentTimeMillis() - threshold && !Main.isUnitTest) {
            LOGGER.fine("Cache hit");
            return this.result;
        }
        try {
            TestResult previousResult;
            long started = System.currentTimeMillis();
            this.result = this.parse();
            this.result.setParentAction((AbstractTestResultAction)this);
            if (this.updated == 0L && this.previousResultTestsCount == -1 && (previousResult = this.findPreviousTestResult()) != null) {
                this.previousResultTestsCount = previousResult.getTotalCount();
                this.previousResultTestsTime = previousResult.getDuration();
            }
            if (this.previousResultTestsCount != -1) {
                this.progress = new TestProgress(this.previousResultTestsCount, this.previousResultTestsTime, this.result);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Parsing of {0} test results took {1}ms", new Object[]{this.result.getTotalCount(), System.currentTimeMillis() - started});
            }
            this.updated = System.currentTimeMillis();
        }
        catch (AbortException ex) {
            LOGGER.fine("No new reports found.");
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.WARNING, "Unable to parse", ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Unable to parse", ex);
        }
        return this.result;
    }

    protected long getParseInterval() {
        return Math.max(5000L, this.run.getEstimatedDuration() / 100L);
    }

    public int getFailCount() {
        if (this.getResult() == null) {
            return 0;
        }
        return this.getResult().getFailCount();
    }

    public List<? extends hudson.tasks.test.TestResult> getFailedTests() {
        if (this.getResult() == null) {
            return Collections.emptyList();
        }
        return this.getResult().getFailedTests();
    }

    public int getTotalCount() {
        if (this.getResult() == null) {
            return 0;
        }
        return this.getResult().getTotalCount();
    }

    public TestResult getTarget() {
        if (!this.run.isBuilding()) {
            LOGGER.log(Level.WARNING, "Dangling RealtimeTestResultAction on {0}. Probably not finalized correctly.", this.run);
            AbstractRealtimeTestResultAction.detachAllFrom(this.run);
            throw new HttpRedirect(this.run.getUrl());
        }
        if (this.getResult() != null) {
            return this.getResult();
        }
        return new TestResult();
    }

    public TestProgress getTestProgress() {
        return this.progress;
    }

    static void saveBuild(Run<?, ?> build) {
        try {
            build.save();
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
    }

    static void detachAllFrom(Run<?, ?> build) {
        if (build.removeActions(AbstractRealtimeTestResultAction.class)) {
            LOGGER.log(Level.FINE, "Detaching RealtimeTestResultAction from {0}", build);
            AbstractRealtimeTestResultAction.saveBuild(build);
        }
    }

    @CheckForNull
    protected static TestResult findPreviousTestResult(Run<?, ?> b) {
        for (int i = 0; i < 20 && (b = b.getPreviousBuild()) != null; ++i) {
            Object o;
            AbstractTestResultAction tra;
            if (!RESULTS_OF_BUILDS_TO_CONSIDER.contains(b.getResult()) || (tra = (AbstractTestResultAction)b.getAction(AbstractTestResultAction.class)) == null || !((o = tra.getResult()) instanceof TestResult)) continue;
            return (TestResult)o;
        }
        return null;
    }
}

