/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.junitrealtimetestreporter;

import hudson.tasks.junit.TestResult;

public class TestProgress {
    private int expectedTests;
    private float expectedTime;
    private int completedTests;
    private float completedTime;
    private int completedTestsPercentage = -1;
    private int completedTimePercentage = -1;
    private String estimatedRemainingTime;

    public TestProgress(int expectedTests, float expectedTime, TestResult result) {
        this.expectedTests = expectedTests;
        this.expectedTime = expectedTime;
        this.completedTests = result.getTotalCount();
        this.completedTime = result.getDuration();
    }

    public String getEstimatedRemainingTime() {
        if (this.estimatedRemainingTime == null) {
            float remaining = Math.max(this.expectedTime - this.completedTime, 0.0f);
            int minutes = (int)Math.floor((double)remaining / 60.0);
            int seconds = (int)remaining % 60;
            this.estimatedRemainingTime = minutes > 0 ? String.format("%d min %d sec", minutes, seconds) : String.format("%d sec", seconds);
        }
        return this.estimatedRemainingTime;
    }

    public int getCompletedTestsPercentage() {
        if (this.completedTestsPercentage < 0) {
            this.completedTestsPercentage = this.expectedTests == 0 ? 100 : Math.min((int)Math.floor((double)this.completedTests / (double)this.expectedTests * 100.0), 100);
        }
        return this.completedTestsPercentage;
    }

    public int getTestsLeftPercentage() {
        return 100 - this.getCompletedTestsPercentage();
    }

    public int getCompletedTimePercentage() {
        if (this.completedTimePercentage < 0) {
            if (this.expectedTime == 0.0f) {
                this.completedTimePercentage = 100;
            }
            this.completedTimePercentage = Math.min((int)Math.floor((double)this.completedTime / (double)this.expectedTime * 100.0), 100);
        }
        return this.completedTimePercentage;
    }

    public int getTimeLeftPercentage() {
        return 100 - this.getCompletedTimePercentage();
    }

    public int getCompletedTests() {
        return this.completedTests;
    }

    public int getExpectedTests() {
        return this.expectedTests;
    }

    public float getCompletedTime() {
        return this.completedTime;
    }

    public float getExpectedTime() {
        return this.expectedTime;
    }
}

