/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.junitrealtimetestreporter;

import hudson.Util;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.TaskListener;
import hudson.tasks.junit.JUnitParser;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.junit.TestResult;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.jenkinsci.plugins.junitrealtimetestreporter.AbstractRealtimeTestResultAction;
import org.jenkinsci.plugins.junitrealtimetestreporter.DummyArchiver;

public class RealtimeTestResultAction
extends AbstractRealtimeTestResultAction {
    private static final Logger LOGGER = Logger.getLogger(RealtimeTestResultAction.class.getName());

    public String getDisplayName() {
        return "Realtime Test Result";
    }

    public String getUrlName() {
        return "realtimeTestReport";
    }

    @Override
    protected TestResult parse() throws IOException, InterruptedException {
        JUnitResultArchiver archiver = RealtimeTestResultAction.getArchiver(this.owner);
        return new JUnitParser(archiver.isKeepLongStdio(), true).parse(this.getGlob(archiver), this.owner, null, TaskListener.NULL);
    }

    private String getGlob(JUnitResultArchiver archiver) {
        String glob = archiver.getTestResults();
        if (this.owner instanceof MatrixBuild) {
            String[] independentChunks = glob.split("[, ]+");
            for (int i = 0; i < independentChunks.length; ++i) {
                independentChunks[i] = "**/" + independentChunks[i];
            }
            glob = Util.join(Arrays.asList(independentChunks), (String)", ");
        }
        return glob;
    }

    static JUnitResultArchiver getArchiver(AbstractBuild<?, ?> build) {
        if (build.getClass().getName().equals("hudson.maven.MavenModuleSetBuild") || build.getClass().getName().equals("hudson.maven.MavenBuild")) {
            return new DummyArchiver();
        }
        return (JUnitResultArchiver)RealtimeTestResultAction.getProject(build).getPublishersList().get(JUnitResultArchiver.class);
    }

    private static AbstractProject<?, ?> getProject(AbstractBuild<?, ?> build) {
        return (AbstractProject)build.getRootBuild().getParent();
    }

    @Override
    protected TestResult findPreviousTestResult() throws IOException, InterruptedException {
        return RealtimeTestResultAction.findPreviousTestResult(this.run);
    }

    static void detachFrom(AbstractBuild<?, ?> build) {
        List actions = build.getActions();
        Iterator iterator = actions.iterator();
        boolean removed = false;
        while (iterator.hasNext()) {
            Action action = (Action)iterator.next();
            if (!(action instanceof RealtimeTestResultAction)) continue;
            LOGGER.info("Detaching RealtimeTestResultAction from " + String.valueOf(build));
            actions.remove(action);
            ((RealtimeTestResultAction)action).result = null;
            removed = true;
        }
        if (removed) {
            try {
                build.save();
            }
            catch (IOException ex) {
                throw new AssertionError((Object)ex);
            }
        }
    }
}

