/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.junitrealtimetestreporter;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.junit.JUnitTask;
import hudson.tasks.junit.StdioRetention;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.junit.TestResultSummary;
import hudson.tasks.junit.pipeline.JUnitResultsStepExecution;
import hudson.tasks.test.PipelineTestDetails;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.junit.storage.FileJunitTestResultStorage;
import io.jenkins.plugins.junit.storage.JunitTestResultStorage;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.junitrealtimetestreporter.AbstractRealtimeTestResultAction;
import org.jenkinsci.plugins.junitrealtimetestreporter.PipelineRealtimeTestResultAction;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.pickles.PickleFactory;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.GeneralNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.pickles.XStreamPickle;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class RealtimeJUnitStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(RealtimeJUnitStep.class.getName());
    private final String testResults;
    private String stdioRetention;
    private List<TestDataPublisher> testDataPublishers;
    private Double healthScaleFactor;
    private boolean allowEmptyResults;
    private boolean skipMarkingBuildUnstable;
    private Long parseInterval;

    @DataBoundConstructor
    public RealtimeJUnitStep(String testResults) {
        this.testResults = testResults;
    }

    public String getTestResults() {
        return this.testResults;
    }

    @Deprecated
    public boolean isKeepLongStdio() {
        return StdioRetention.parse((String)this.stdioRetention) == StdioRetention.ALL;
    }

    @DataBoundSetter
    @Deprecated
    public void setKeepLongStdio(boolean keepLongStdio) {
        this.stdioRetention = StdioRetention.fromKeepLongStdio((boolean)keepLongStdio).name();
    }

    public String getStdioRetention() {
        return this.stdioRetention == null ? StdioRetention.DEFAULT.name() : this.stdioRetention;
    }

    @DataBoundSetter
    public void setStdioRetention(String stdioRetention) {
        this.stdioRetention = stdioRetention;
    }

    @NonNull
    public List<TestDataPublisher> getTestDataPublishers() {
        return this.testDataPublishers == null ? Collections.emptyList() : this.testDataPublishers;
    }

    @DataBoundSetter
    public void setTestDataPublishers(@NonNull List<TestDataPublisher> testDataPublishers) {
        this.testDataPublishers = testDataPublishers;
    }

    public double getHealthScaleFactor() {
        return this.healthScaleFactor == null ? 1.0 : this.healthScaleFactor;
    }

    @DataBoundSetter
    public void setHealthScaleFactor(double healthScaleFactor) {
        this.healthScaleFactor = Math.max(0.0, healthScaleFactor);
    }

    public boolean isAllowEmptyResults() {
        return this.allowEmptyResults;
    }

    @DataBoundSetter
    public void setAllowEmptyResults(boolean allowEmptyResults) {
        this.allowEmptyResults = allowEmptyResults;
    }

    public boolean isSkipMarkingBuildUnstable() {
        return this.skipMarkingBuildUnstable;
    }

    @DataBoundSetter
    public void setSkipMarkingBuildUnstable(boolean skipMarkingBuildUnstable) {
        this.skipMarkingBuildUnstable = skipMarkingBuildUnstable;
    }

    public Long getParseInterval() {
        return this.parseInterval;
    }

    @DataBoundSetter
    public void setParseInterval(Long parseInterval) {
        this.parseInterval = parseInterval == null || parseInterval == 0L ? null : parseInterval;
    }

    public StepExecution start(StepContext context) throws Exception {
        JUnitResultArchiver delegate = new JUnitResultArchiver(this.testResults);
        delegate.setAllowEmptyResults(this.allowEmptyResults);
        delegate.setHealthScaleFactor(this.getHealthScaleFactor());
        delegate.setStdioRetention(this.stdioRetention);
        delegate.setTestDataPublishers(this.getTestDataPublishers());
        delegate.setSkipMarkingBuildUnstable(this.isSkipMarkingBuildUnstable());
        Long parseInterval = this.parseInterval != null ? Long.valueOf(this.parseInterval * 1000L) : null;
        return new Execution2(context, delegate, parseInterval);
    }

    private static void finished(String id, JUnitResultArchiver archiver, StepContext context, boolean success) throws Exception {
        Run r = (Run)context.get(Run.class);
        TestResult provisional = null;
        for (PipelineRealtimeTestResultAction a : r.getActions(PipelineRealtimeTestResultAction.class)) {
            if (!a.id.equals(id)) continue;
            provisional = a.getResult();
            r.removeAction((Action)a);
            LOGGER.log(Level.FINE, "clearing {0} from {1}", new Object[]{id, r});
            AbstractRealtimeTestResultAction.saveBuild(r);
            break;
        }
        if (!success) {
            archiver.setAllowEmptyResults(true);
        }
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        try {
            int testFailures;
            FilePath workspace = (FilePath)context.get(FilePath.class);
            workspace.mkdirs();
            Launcher launcher = (Launcher)context.get(Launcher.class);
            FlowNode node = (FlowNode)context.get(FlowNode.class);
            List enclosingBlocks = JUnitResultsStepExecution.getEnclosingStagesAndParallels((FlowNode)node);
            PipelineTestDetails pipelineTestDetails = new PipelineTestDetails();
            pipelineTestDetails.setNodeId(id);
            pipelineTestDetails.setEnclosingBlocks(JUnitResultsStepExecution.getEnclosingBlockIds((List)enclosingBlocks));
            pipelineTestDetails.setEnclosingBlockNames(JUnitResultsStepExecution.getEnclosingBlockNames((List)enclosingBlocks));
            TestResultSummary summary = JUnitResultArchiver.parseAndSummarize((JUnitTask)archiver, (PipelineTestDetails)pipelineTestDetails, (Run)r, (FilePath)workspace, (Launcher)launcher, (TaskListener)listener);
            if (summary.getFailCount() > 0 && (testFailures = summary.getFailCount()) > 0) {
                node.addOrReplaceAction((Action)new WarningAction(Result.UNSTABLE).withMessage(testFailures + " tests failed"));
                if (!archiver.isSkipMarkingBuildUnstable()) {
                    r.setResult(Result.UNSTABLE);
                }
            }
        }
        catch (Exception x) {
            if (provisional != null) {
                listener.getLogger().println("Final archiving failed; recording " + provisional.getTotalCount() + " provisional test results.");
                JunitTestResultStorage storage = JunitTestResultStorage.find();
                if (storage instanceof FileJunitTestResultStorage) {
                    r.addAction((Action)new TestResultAction(r, provisional, listener));
                } else {
                    JunitTestResultStorage.RemotePublisher publisher = storage.createRemotePublisher(r);
                    publisher.publish(provisional, listener);
                    r.addAction((Action)new TestResultAction(r, new TestResult(storage.load(r.getParent().getFullName(), r.getNumber())), listener));
                }
            }
            throw x;
        }
    }

    static class Execution2
    extends GeneralNonBlockingStepExecution {
        private final JUnitResultArchiver archiver;
        private final Long parseInterval;

        Execution2(StepContext context, JUnitResultArchiver archiver, Long parseInterval) {
            super(context);
            this.archiver = archiver;
            this.parseInterval = parseInterval;
        }

        public boolean start() {
            this.run(this::doStart);
            return false;
        }

        private void doStart() throws IOException, InterruptedException {
            StepContext context = this.getContext();
            Run r = (Run)context.get(Run.class);
            FlowNode flowNode = (FlowNode)context.get(FlowNode.class);
            String id = Objects.requireNonNull(flowNode).getId();
            Objects.requireNonNull(r).addAction((Action)new PipelineRealtimeTestResultAction(id, (FilePath)context.get(FilePath.class), this.archiver.isKeepLongStdio(), this.archiver.getTestResults(), context, this.parseInterval));
            AbstractRealtimeTestResultAction.saveBuild(r);
            context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback2(id, this.archiver)).start();
        }

        private final class Callback2
        extends BodyExecutionCallback {
            private final String id;
            private final JUnitResultArchiver archiver;
            private static final long serialVersionUID = 1L;

            Callback2(String id, JUnitResultArchiver archiver) {
                this.id = id;
                this.archiver = archiver;
            }

            public void onSuccess(StepContext context, Object result) {
                Execution2.this.run(() -> {
                    try {
                        RealtimeJUnitStep.finished(this.id, this.archiver, context, true);
                    }
                    catch (Exception x) {
                        context.onFailure((Throwable)x);
                        return;
                    }
                    context.onSuccess(result);
                });
            }

            public void onFailure(StepContext context, Throwable t) {
                Execution2.this.run(() -> {
                    try {
                        RealtimeJUnitStep.finished(this.id, this.archiver, context, false);
                    }
                    catch (Exception x) {
                        t.addSuppressed(x);
                    }
                    context.onFailure(t);
                });
            }
        }
    }

    @Extension
    public static class Pickler
    extends PickleFactory {
        public Pickle writeReplace(Object object) {
            if (object instanceof JUnitResultArchiver || object instanceof TestDataPublisher) {
                return new XStreamPickle(object);
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "realtimeJUnit";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public String getDisplayName() {
            return "Display JUnit test results as they appear";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(FilePath.class, Run.class, Launcher.class, TaskListener.class, FlowNode.class);
        }

        public Descriptor<?> getDelegateDescriptor() {
            return Jenkins.getInstance().getDescriptor(JUnitResultArchiver.class);
        }

        public ListBoxModel doFillStdioRetentionItems(@QueryParameter(value="stdioRetention") String value) {
            JUnitResultArchiver.DescriptorImpl descriptor = (JUnitResultArchiver.DescriptorImpl)Jenkins.get().getDescriptorByType(JUnitResultArchiver.DescriptorImpl.class);
            return descriptor.doFillStdioRetentionItems(value);
        }
    }

    @Deprecated
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Handled by 'Pickler' below")
    private static final class Callback
    extends BodyExecutionCallback {
        private final String id;
        private final JUnitResultArchiver archiver;

        Callback(String id, JUnitResultArchiver archiver) {
            this.id = id;
            this.archiver = archiver;
        }

        public void onSuccess(StepContext context, Object result) {
            try {
                RealtimeJUnitStep.finished(this.id, this.archiver, context, true);
            }
            catch (Exception x) {
                context.onFailure((Throwable)x);
                return;
            }
            context.onSuccess(result);
        }

        public void onFailure(StepContext context, Throwable t) {
            try {
                RealtimeJUnitStep.finished(this.id, this.archiver, context, false);
            }
            catch (Exception x) {
                context.onFailure((Throwable)x);
                return;
            }
            context.onFailure(t);
        }
    }

    @Deprecated
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    static class Execution
    extends StepExecution {
        private final JUnitResultArchiver archiver;
        private static final long serialVersionUID = 1L;

        Execution(StepContext context, JUnitResultArchiver archiver) {
            super(context);
            this.archiver = archiver;
        }

        public boolean start() throws IOException, InterruptedException {
            this.doStart();
            return false;
        }

        void doStart() throws IOException, InterruptedException {
            StepContext context = this.getContext();
            Run r = (Run)context.get(Run.class);
            FlowNode flowNode = (FlowNode)context.get(FlowNode.class);
            String id = Objects.requireNonNull(flowNode).getId();
            Objects.requireNonNull(r).addAction((Action)new PipelineRealtimeTestResultAction(id, (FilePath)context.get(FilePath.class), this.archiver.isKeepLongStdio(), this.archiver.getTestResults(), context, null));
            AbstractRealtimeTestResultAction.saveBuild(r);
            context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(id, this.archiver)).start();
        }
    }
}

