/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.junitrealtimetestreporter;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.AbortException;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.tasks.junit.JUnitParser;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.pipeline.JUnitResultsStepExecution;
import hudson.tasks.test.PipelineTestDetails;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.junitrealtimetestreporter.AbstractRealtimeTestResultAction;
import org.jenkinsci.plugins.junitrealtimetestreporter.Messages;
import org.jenkinsci.plugins.workflow.FilePathUtils;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class PipelineRealtimeTestResultAction
extends AbstractRealtimeTestResultAction {
    private static final Logger LOGGER = Logger.getLogger(PipelineRealtimeTestResultAction.class.getName());
    final String id;
    private final String node;
    private final String workspace;
    private final boolean keepLongStdio;
    private final String glob;
    @CheckForNull
    private final transient StepContext context;
    private final Long parseInterval;

    PipelineRealtimeTestResultAction(String id, FilePath ws, boolean keepLongStdio, String glob, StepContext context, Long parseInterval) {
        this.id = id;
        this.node = FilePathUtils.getNodeName((FilePath)ws);
        this.workspace = ws.getRemote();
        this.keepLongStdio = keepLongStdio;
        this.glob = glob;
        this.context = context;
        this.parseInterval = parseInterval;
    }

    public String getDisplayName() {
        if (this.node.isEmpty()) {
            return Messages.PipelineRealtimeTestResultAction_realtime_test_result_on_master();
        }
        return Messages.PipelineRealtimeTestResultAction_realtime_test_result_on_(this.node);
    }

    public String getUrlName() {
        return "realtimeTestReport-" + this.id;
    }

    @Override
    protected long getParseInterval() {
        return this.parseInterval != null ? this.parseInterval.longValue() : super.getParseInterval();
    }

    @Override
    protected TestResult parse() throws IOException, InterruptedException {
        FilePath ws = FilePathUtils.find((String)this.node, (String)this.workspace);
        if (ws != null && ws.isDirectory()) {
            FlowExecutionOwner.Executable executable;
            FlowExecutionOwner flowOwner;
            LOGGER.log(Level.FINE, "parsing {0} in {1} on node {2} for {3}", new Object[]{this.glob, this.workspace, this.node, this.run});
            FlowNode node = null;
            TaskListener listener = TaskListener.NULL;
            if (this.context != null) {
                node = (FlowNode)this.context.get(FlowNode.class);
                listener = (TaskListener)this.context.get(TaskListener.class);
            } else if (this.run instanceof FlowExecutionOwner.Executable && (flowOwner = (executable = (FlowExecutionOwner.Executable)this.run).asFlowExecutionOwner()) != null) {
                FlowExecution flowExecution = flowOwner.getOrNull();
                if (flowExecution != null) {
                    node = flowExecution.getNode(this.id);
                }
                listener = flowOwner.getListener();
            }
            PipelineTestDetails pipelineTestDetails = null;
            if (node != null) {
                List enclosingBlocks = JUnitResultsStepExecution.getEnclosingStagesAndParallels((FlowNode)Objects.requireNonNull(node));
                pipelineTestDetails = new PipelineTestDetails();
                pipelineTestDetails.setNodeId(this.id);
                pipelineTestDetails.setEnclosingBlocks(JUnitResultsStepExecution.getEnclosingBlockIds((List)enclosingBlocks));
                pipelineTestDetails.setEnclosingBlockNames(JUnitResultsStepExecution.getEnclosingBlockNames((List)enclosingBlocks));
            }
            return new JUnitParser(this.keepLongStdio, true).parseResult(this.glob, this.run, pipelineTestDetails, ws, null, listener);
        }
        throw new AbortException("skipping parse in nonexistent workspace for " + String.valueOf(this.run));
    }

    @Override
    @CheckForNull
    protected TestResult findPreviousTestResult() throws IOException, InterruptedException {
        TestResult testResult = PipelineRealtimeTestResultAction.findPreviousTestResult(this.run);
        if (testResult != null) {
            testResult = testResult.getResultByNodes(Arrays.asList(this.id));
        }
        return testResult;
    }
}

