// CHECKSTYLE:OFF

package org.jenkinsci.plugins.junitrealtimetestreporter;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code
     * PipelineRealtimeTestResultAction.realtime_test_result_on_master}:
     * {@code Realtime Test Result on Controller}.
     * 
     * @return
     *     {@code Realtime Test Result on Controller}
     */
    public static String PipelineRealtimeTestResultAction_realtime_test_result_on_master() {
        return holder.format("PipelineRealtimeTestResultAction.realtime_test_result_on_master");
    }

    /**
     * Key {@code
     * PipelineRealtimeTestResultAction.realtime_test_result_on_master}:
     * {@code Realtime Test Result on Controller}.
     * 
     * @return
     *     {@code Realtime Test Result on Controller}
     */
    public static Localizable _PipelineRealtimeTestResultAction_realtime_test_result_on_master() {
        return new Localizable(holder, "PipelineRealtimeTestResultAction.realtime_test_result_on_master");
    }

    /**
     * Key {@code PerJobConfiguration.visualize_test_results_in_real_time}:
     * {@code Visualize test results in real time}.
     * 
     * @return
     *     {@code Visualize test results in real time}
     */
    public static String PerJobConfiguration_visualize_test_results_in_real_time() {
        return holder.format("PerJobConfiguration.visualize_test_results_in_real_time");
    }

    /**
     * Key {@code PerJobConfiguration.visualize_test_results_in_real_time}:
     * {@code Visualize test results in real time}.
     * 
     * @return
     *     {@code Visualize test results in real time}
     */
    public static Localizable _PerJobConfiguration_visualize_test_results_in_real_time() {
        return new Localizable(holder, "PerJobConfiguration.visualize_test_results_in_real_time");
    }

    /**
     * Key {@code PipelineRealtimeTestResultAction.realtime_test_result_on_}:
     * {@code Realtime Test Result on {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Realtime Test Result on {0}}
     */
    public static String PipelineRealtimeTestResultAction_realtime_test_result_on_(Object arg0) {
        return holder.format("PipelineRealtimeTestResultAction.realtime_test_result_on_", arg0);
    }

    /**
     * Key {@code PipelineRealtimeTestResultAction.realtime_test_result_on_}:
     * {@code Realtime Test Result on {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Realtime Test Result on {0}}
     */
    public static Localizable _PipelineRealtimeTestResultAction_realtime_test_result_on_(Object arg0) {
        return new Localizable(holder, "PipelineRealtimeTestResultAction.realtime_test_result_on_", arg0);
    }

}
