/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.junitattachments;

import hudson.FilePath;
import hudson.Util;
import hudson.plugins.junitattachments.AttachmentTestAction;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.TestObject;
import java.util.List;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;

public class TestCaseAttachmentTestAction
extends AttachmentTestAction {
    private static final Pattern ATTACHMENT_PATTERN = Pattern.compile("\\[\\[ATTACHMENT\\|.+]]");
    private final List<String> attachments;
    private final boolean showAttachmentsInStdOut;

    public TestCaseAttachmentTestAction(CaseResult caseResult, FilePath storage, List<String> attachments, boolean showAttachmentsInStdOut) {
        super((TestObject)caseResult, storage);
        this.attachments = attachments;
        this.showAttachmentsInStdOut = showAttachmentsInStdOut;
    }

    public List<String> getAttachments() {
        return this.attachments;
    }

    public String annotate(String text) {
        if (!this.showAttachmentsInStdOut) {
            text = ATTACHMENT_PATTERN.matcher(text).replaceAll("").stripTrailing();
        }
        String url = Jenkins.get().getRootUrl() + this.testObject.getUrl() + "/attachments/";
        for (String attachment : this.attachments) {
            text = text.replace(attachment, "<a href=\"" + url + attachment + "\">" + attachment + "</a>");
        }
        return text;
    }

    public static String getUrl(String filename) {
        return "attachments/" + Util.rawEncode((String)filename);
    }
}

