/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.local;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.plugins.itemstorage.GlobalItemStorage;
import jenkins.plugins.itemstorage.ItemStorage;
import jenkins.plugins.itemstorage.ItemStorageDescriptor;
import jenkins.plugins.itemstorage.Messages;
import jenkins.plugins.itemstorage.local.LocalObjectPath;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class LocalItemStorage
extends ItemStorage<LocalObjectPath> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(LocalItemStorage.class.getName());
    private String root;

    @DataBoundConstructor
    public LocalItemStorage() {
    }

    @DataBoundSetter
    public void setRoot(String root) {
        this.root = root;
    }

    public String getRoot() {
        return this.root;
    }

    @Override
    public LocalObjectPath getObjectPath(Item item, String path) {
        return new LocalObjectPath(this.getItemRoot(item).child(path));
    }

    @Override
    public LocalObjectPath getObjectPathForBranch(Item item, String path, String branch) {
        FilePath parent = this.getItemRoot(item).getParent();
        if (parent == null) {
            return null;
        }
        FilePath branchPath = parent.child(branch);
        return new LocalObjectPath(branchPath.child(path));
    }

    private FilePath getItemRoot(Item item) {
        if (StringUtils.isNotEmpty((CharSequence)this.root)) {
            return this.getItemRoot(item.getFullName());
        }
        return new FilePath(item.getRootDir());
    }

    private FilePath getItemRoot(String itemFullName) {
        return new FilePath(new File(this.root)).child(itemFullName);
    }

    @Extension(optional=true)
    public static final class LocalItemListener
    extends ItemListener {
        public void onDeleted(Item item) {
            LocalItemStorage storage = LocalItemListener.lookupStorage();
            if (storage == null || storage.root == null) {
                return;
            }
            try {
                storage.getItemRoot(item).deleteRecursive();
            }
            catch (IOException | InterruptedException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LOG.warning("failed to delete item storage for " + item.getFullName() + ": " + e.getMessage());
            }
        }

        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            LocalItemStorage storage = LocalItemListener.lookupStorage();
            if (storage == null || storage.root == null) {
                return;
            }
            try {
                storage.getItemRoot(oldFullName).renameTo(storage.getItemRoot(newFullName));
            }
            catch (IOException | InterruptedException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LOG.warning("failed to rename item storage for " + item.getFullName() + ": " + e.getMessage());
            }
        }

        private static LocalItemStorage lookupStorage() {
            ItemStorage<?> storage = GlobalItemStorage.get().getStorage();
            if (storage instanceof LocalItemStorage) {
                return (LocalItemStorage)storage;
            }
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends ItemStorageDescriptor<LocalObjectPath> {
        @NonNull
        public String getDisplayName() {
            return Messages.LocalItemStorage_DisplayName();
        }
    }
}

