/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.local;

import hudson.FilePath;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.Job;
import java.io.IOException;
import jenkins.plugins.itemstorage.ObjectPath;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class LocalObjectPath
extends ObjectPath {
    private final FilePath file;

    public LocalObjectPath(FilePath file) {
        this.file = file;
    }

    @Override
    public ObjectPath child(String path) throws IOException, InterruptedException {
        return new LocalObjectPath(this.file.child(path));
    }

    @Override
    public void copyTo(FilePath target) throws IOException, InterruptedException {
        this.file.copyTo(target);
    }

    @Override
    public void copyFrom(FilePath source) throws IOException, InterruptedException {
        this.file.copyFrom(source);
    }

    @Override
    public boolean exists() throws IOException, InterruptedException {
        return this.file.exists();
    }

    @Override
    public void deleteRecursive() throws IOException, InterruptedException {
        this.file.deleteRecursive();
    }

    @Override
    public HttpResponse browse(StaplerRequest2 request, StaplerResponse2 response, Job<?, ?> job, String name) {
        return new DirectoryBrowserSupport(job, this.file, "Cache of " + name, "folder.png", true);
    }

    protected String getPath() {
        return this.file.getRemote();
    }
}

