/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jobcacher.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.plugins.jobcacher.Cache;
import jenkins.plugins.jobcacher.CacheDescriptor;
import jenkins.plugins.jobcacher.Messages;
import jenkins.plugins.jobcacher.pipeline.CacheStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CacheStep
extends Step {
    private final List<Cache> caches;
    private Long maxCacheSize;
    private boolean skipSave;
    private boolean skipRestore;
    private String defaultBranch;

    @DataBoundConstructor
    public CacheStep(Long maxCacheSize, List<Cache> caches) {
        this.maxCacheSize = maxCacheSize;
        this.caches = caches;
    }

    @DataBoundSetter
    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @DataBoundSetter
    public void setMaxCacheSize(Long maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public Long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @DataBoundSetter
    public void setSkipSave(boolean skipSave) {
        this.skipSave = skipSave;
    }

    public boolean getSkipSave() {
        return this.skipSave;
    }

    @DataBoundSetter
    public void setSkipRestore(boolean skipRestore) {
        this.skipRestore = skipRestore;
    }

    public boolean getSkipRestore() {
        return this.skipRestore;
    }

    public List<Cache> getCaches() {
        return this.caches;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new CacheStepExecution(context, this.maxCacheSize, this.skipSave, this.skipRestore, this.caches, this.defaultBranch);
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.emptySet();
        }

        public String getFunctionName() {
            return "cache";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.CacheStep_DisplayName();
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public List<CacheDescriptor> getCacheDescriptors() {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins != null) {
                return jenkins.getDescriptorList(Cache.class);
            }
            return Collections.emptyList();
        }
    }
}

