/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.ExtensionList;
import hudson.Plugin;
import hudson.model.User;
import hudson.plugins.jobConfigHistory.FileHistoryDao;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.JobConfigHistoryStrategy;
import hudson.plugins.jobConfigHistory.MimickedUser;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;

public final class PluginUtils {
    private PluginUtils() {
    }

    public static JobConfigHistory getPlugin() {
        return (JobConfigHistory)((Object)ExtensionList.lookupSingleton(JobConfigHistory.class));
    }

    public static JobConfigHistoryStrategy getHistoryDao() {
        JobConfigHistory plugin = PluginUtils.getPlugin();
        return PluginUtils.getHistoryDao(plugin);
    }

    public static JobConfigHistoryStrategy getAnonymousHistoryDao() {
        JobConfigHistory plugin = PluginUtils.getPlugin();
        return PluginUtils.getAnonymousHistoryDao(plugin);
    }

    static JobConfigHistoryStrategy getSystemHistoryDao() {
        JobConfigHistory plugin = PluginUtils.getPlugin();
        return PluginUtils.getSystemHistoryDao(plugin);
    }

    public static JobConfigHistoryStrategy getHistoryDao(JobConfigHistory plugin) {
        return PluginUtils.getHistoryDao(plugin, User.current());
    }

    public static JobConfigHistoryStrategy getAnonymousHistoryDao(JobConfigHistory plugin) {
        return PluginUtils.getHistoryDao(plugin, (User)null);
    }

    static JobConfigHistoryStrategy getSystemHistoryDao(JobConfigHistory plugin) {
        return PluginUtils.getHistoryDao(plugin, new MimickedUser("SYSTEM", "SYSTEM"));
    }

    public static JobConfigHistoryStrategy getHistoryDao(JobConfigHistory plugin, User user) {
        return PluginUtils.getHistoryDao(plugin, new MimickedUser(user));
    }

    public static JobConfigHistoryStrategy getHistoryDao(JobConfigHistory plugin, MimickedUser mimickedUser) {
        String maxHistoryEntriesAsString = plugin.getMaxHistoryEntries();
        int maxHistoryEntries = 0;
        try {
            maxHistoryEntries = Integer.parseInt(maxHistoryEntriesAsString);
        }
        catch (NumberFormatException e) {
            maxHistoryEntries = 0;
        }
        return new FileHistoryDao(plugin.getConfiguredHistoryRootDir(), new File(Jenkins.get().root.getPath()), mimickedUser, maxHistoryEntries, !plugin.getSkipDuplicateHistory());
    }

    public static boolean isUserExcluded(JobConfigHistory plugin) {
        String user = Jenkins.getAuthentication().getName();
        if (plugin.getExcludedUsers() != null) {
            String[] segs;
            String excludedUsers = plugin.getExcludedUsers().trim();
            for (String seg : segs = excludedUsers.split(Pattern.quote(","))) {
                if (!seg.trim().equals(user)) continue;
                return true;
            }
        }
        return false;
    }

    public static Date parsedDate(String timeStamp) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").parse(timeStamp);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Could not parse Date" + timeStamp, ex);
        }
    }

    public static boolean isMavenPluginAvailable() {
        try {
            Plugin plugin = Jenkins.get().getPlugin("maven-plugin");
            return plugin != null && plugin.getWrapper().isActive();
        }
        catch (Exception e) {
            return false;
        }
    }
}

