/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DiffException;
import com.github.difflib.patch.Patch;
import com.github.difflib.text.DiffRow;
import com.github.difflib.text.DiffRowGenerator;
import hudson.plugins.jobConfigHistory.SideBySideView;
import java.util.List;

public class GetDiffLines {
    private final List<String> diffLines;
    private final SideBySideView view;
    private final DiffRowGenerator dfg;

    public GetDiffLines(List<String> diffLines) {
        DiffRowGenerator.Builder builder = DiffRowGenerator.create();
        builder.columnWidth(Integer.MAX_VALUE);
        this.dfg = builder.build();
        this.diffLines = diffLines;
        this.view = new SideBySideView();
    }

    public List<SideBySideView.Line> get() throws DiffException {
        Patch diff = UnifiedDiffUtils.parseUnifiedDiff(this.diffLines);
        int previousLeftPos = 0;
        for (AbstractDelta delta : diff.getDeltas()) {
            previousLeftPos = this.deltaLoop((AbstractDelta<String>)delta, previousLeftPos);
        }
        this.view.clearDuplicateLines();
        return this.view.getLines();
    }

    int deltaLoop(AbstractDelta<String> delta, int previousLeftPos) {
        return new DeltaLoop(this.view, this.dfg, delta).loop(previousLeftPos);
    }

    static class DeltaLoop {
        private final SideBySideView view;
        private final DiffRowGenerator dfg;
        private final AbstractDelta<?> delta;
        private int leftPos;
        private int rightPos;

        public DeltaLoop(SideBySideView view, DiffRowGenerator dfg, AbstractDelta<?> delta) {
            this.view = view;
            this.dfg = dfg;
            this.delta = delta;
        }

        int loop(int previousLeftPos) {
            Chunk original = this.delta.getSource();
            Chunk revised = this.delta.getTarget();
            List diffRows = this.dfg.generateDiffRows(original.getLines(), revised.getLines());
            this.leftPos = original.getPosition() + 1;
            this.rightPos = revised.getPosition() + 1;
            if (previousLeftPos > 0 && this.leftPos - previousLeftPos > 1) {
                SideBySideView.Line skippingLine = new SideBySideView.Line();
                skippingLine.setSkipping(true);
                this.view.addLine(skippingLine);
            }
            for (DiffRow row : diffRows) {
                previousLeftPos = this.processDiffRow(row);
            }
            return previousLeftPos;
        }

        int processDiffRow(DiffRow row) {
            DiffRow.Tag tag = row.getTag();
            SideBySideView.Line line = new SideBySideView.Line();
            SideBySideView.Line.Item left = line.getLeft();
            SideBySideView.Line.Item right = line.getRight();
            String oldLine = row.getOldLine();
            String newLine = row.getNewLine();
            if (tag == DiffRow.Tag.INSERT) {
                left.setCssClass("diff_original");
                right.setLineNumber(this.rightPos);
                right.setText(newLine);
                right.setCssClass("diff_revised");
                ++this.rightPos;
            } else if (tag == DiffRow.Tag.CHANGE) {
                if (oldLine != null && !oldLine.isEmpty()) {
                    left.setLineNumber(this.leftPos);
                    left.setText(oldLine);
                    ++this.leftPos;
                }
                left.setCssClass("diff_original");
                if (newLine != null && !newLine.isEmpty()) {
                    right.setLineNumber(this.rightPos);
                    right.setText(newLine);
                    ++this.rightPos;
                }
                right.setCssClass("diff_revised");
            } else if (tag == DiffRow.Tag.DELETE) {
                left.setLineNumber(this.leftPos);
                left.setText(oldLine);
                left.setCssClass("diff_original");
                ++this.leftPos;
                right.setCssClass("diff_revised");
            } else if (tag == DiffRow.Tag.EQUAL) {
                left.setLineNumber(this.leftPos);
                left.setText(oldLine);
                ++this.leftPos;
                right.setLineNumber(this.rightPos);
                right.setText(newLine);
                ++this.rightPos;
            } else {
                throw new IllegalStateException("Unknown tag pattern: " + String.valueOf(tag));
            }
            line.setTag(tag);
            this.view.addLine(line);
            return this.leftPos;
        }
    }
}

