/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.EphemeralNode;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.SlaveComputer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class NodeLocalConfiguration
extends NodeProperty<Node> {
    static final Logger LOG = Logger.getLogger(NodeLocalConfiguration.class.getName());
    private static final Map<Node, String> lastChangeReasonCommentByNode = Collections.synchronizedMap(new HashMap());
    private final String changeReasonComment;

    static Optional<String> lastChangeReasonComment(Node node) {
        return Optional.ofNullable(lastChangeReasonCommentByNode.remove(node));
    }

    @DataBoundConstructor
    public NodeLocalConfiguration(String changeReasonComment) {
        this.changeReasonComment = changeReasonComment;
    }

    public String getChangeReasonComment() {
        return "";
    }

    @Extension
    public static class DescriptorImpl
    extends NodePropertyDescriptor {
        public DescriptorImpl() {
            super(NodeLocalConfiguration.class);
        }

        @NonNull
        public String getDisplayName() {
            return "changeReasonComment_holder";
        }

        public boolean isApplicable(Node n) {
            return n != null && !(n instanceof AbstractCloudSlave) && !(n instanceof EphemeralNode);
        }

        @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="JavaDoc says it is always Non-null")
        public NodeProperty<Node> newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            Slave n;
            NodeLocalConfiguration nlc = (NodeLocalConfiguration)super.newInstance(req, formData);
            SlaveComputer sc = (SlaveComputer)req.findAncestorObject(SlaveComputer.class);
            Slave slave = n = null == sc ? null : sc.getNode();
            if (this.isApplicable((Node)n)) {
                lastChangeReasonCommentByNode.put((Node)n, Util.fixEmptyAndTrim((String)nlc.changeReasonComment));
            }
            return nlc;
        }

        public boolean configure(StaplerRequest2 request, JSONObject jsonObject) throws Descriptor.FormException {
            throw new Descriptor.FormException("form exception", "localValues.changeReasonComment");
        }

        public boolean getShowChangeReasonCommentWindow() {
            return PluginUtils.getPlugin().getShowChangeReasonCommentWindow();
        }

        public boolean getChangeReasonCommentIsMandatory() {
            return PluginUtils.getPlugin().getChangeReasonCommentIsMandatory();
        }

        public boolean isDialogEnabled() {
            return !PluginUtils.isUserExcluded(PluginUtils.getPlugin()) && this.getShowChangeReasonCommentWindow();
        }
    }
}

