/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import hudson.XmlFile;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import java.io.IOException;

public class LazyHistoryDescr
extends HistoryDescr {
    private final XmlFile historyDescriptionFile;
    HistoryDescr historyDescr = HistoryDescr.EMPTY_HISTORY_DESCR;

    public LazyHistoryDescr(XmlFile historyDescriptionFile) {
        super(null, null, null, null, null, null);
        this.historyDescriptionFile = historyDescriptionFile;
    }

    @Override
    public String getUser() {
        return this.loadAndGetHistory().getUser();
    }

    @Override
    public String getUserID() {
        return this.loadAndGetHistory().getUserID();
    }

    @Override
    public String getOperation() {
        return this.loadAndGetHistory().getOperation();
    }

    @Override
    public String getCurrentName() {
        return this.loadAndGetHistory().getCurrentName();
    }

    @Override
    public String getOldName() {
        return this.loadAndGetHistory().getOldName();
    }

    @Override
    public String getTimestamp() {
        return this.loadAndGetHistory().getTimestamp();
    }

    @Override
    public String getChangeReasonComment() {
        return this.loadAndGetHistory().getChangeReasonComment();
    }

    private HistoryDescr loadAndGetHistory() {
        if (this.historyDescr == HistoryDescr.EMPTY_HISTORY_DESCR) {
            try {
                this.historyDescr = (HistoryDescr)this.historyDescriptionFile.read();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to read " + String.valueOf(this.historyDescriptionFile.getFile()), ex);
            }
            catch (CannotResolveClassException ex) {
                throw new RuntimeException(String.valueOf(this.historyDescriptionFile.getFile()) + " is not a history description", ex);
            }
        }
        return this.historyDescr;
    }
}

