/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.plugins.jobConfigHistory.HistoryDao;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.PluginUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class JobConfigHistorySaveableListener
extends SaveableListener {
    private static final Logger LOG = Logger.getLogger(JobConfigHistorySaveableListener.class.getName());

    public void onChange(Saveable o, XmlFile file) {
        JobConfigHistory plugin = this.getPlugin();
        LOG.log(Level.FINEST, "In onChange for {0}", o);
        if (plugin.isSaveable(o, file) && !PluginUtils.isUserExcluded(plugin)) {
            HistoryDao configHistoryListenerHelper = this.getHistoryDao(plugin);
            configHistoryListenerHelper.saveItem(file);
        }
        LOG.log(Level.FINEST, "onChange for {0} done.", o);
    }

    @NonNull
    JobConfigHistory getPlugin() {
        return PluginUtils.getPlugin();
    }

    @Deprecated
    HistoryDao getHistoryDao() {
        return this.getHistoryDao(PluginUtils.getPlugin());
    }

    HistoryDao getHistoryDao(JobConfigHistory plugin) {
        return InitMilestone.COMPLETED == Jenkins.get().getInitLevel() ? PluginUtils.getHistoryDao(plugin) : PluginUtils.getSystemHistoryDao(plugin);
    }
}

