/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jobimport.utils;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Strings;
import hudson.model.Item;
import hudson.security.ACL;
import java.util.Collections;
import java.util.List;
import org.acegisecurity.Authentication;

public final class CredentialsUtils {
    private CredentialsUtils() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static NullSafeCredentials getCredentials(String credentialId) {
        StandardUsernamePasswordCredentials cred;
        if (!Strings.isNullOrEmpty((String)credentialId) && (cred = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull(CredentialsUtils.allCredentials(), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId))) != null) {
            return new NullSafeCredentials(cred.getUsername(), cred.getPassword().getPlainText());
        }
        return new NullSafeCredentials();
    }

    @Deprecated
    public static List<StandardUsernamePasswordCredentials> allCredentials() {
        return CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)null, (Authentication)ACL.SYSTEM, Collections.emptyList());
    }

    public static final class NullSafeCredentials {
        public final String username;
        public final String password;

        NullSafeCredentials(String username, String password) {
            this.username = this.checkNotNull(username);
            this.password = this.checkNotNull(password);
        }

        NullSafeCredentials() {
            this.username = "";
            this.password = "";
        }

        private <T> T checkNotNull(T reference) {
            if (reference == null) {
                throw new NullPointerException();
            }
            return reference;
        }
    }
}

