// CHECKSTYLE:OFF

package org.jenkins.ci.plugins.jobimport;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Job.Import.Plugin.Import.Success}: {@code SUCCESS}.
     * 
     * @return
     *     {@code SUCCESS}
     */
    public static String Job_Import_Plugin_Import_Success() {
        return holder.format("Job.Import.Plugin.Import.Success");
    }

    /**
     * Key {@code Job.Import.Plugin.Import.Success}: {@code SUCCESS}.
     * 
     * @return
     *     {@code SUCCESS}
     */
    public static Localizable _Job_Import_Plugin_Import_Success() {
        return new Localizable(holder, "Job.Import.Plugin.Import.Success");
    }

    /**
     * Key {@code Job.Import.Plugin.PermissionGroup}: {@code Job Import}.
     * 
     * @return
     *     {@code Job Import}
     */
    public static String Job_Import_Plugin_PermissionGroup() {
        return holder.format("Job.Import.Plugin.PermissionGroup");
    }

    /**
     * Key {@code Job.Import.Plugin.PermissionGroup}: {@code Job Import}.
     * 
     * @return
     *     {@code Job Import}
     */
    public static Localizable _Job_Import_Plugin_PermissionGroup() {
        return new Localizable(holder, "Job.Import.Plugin.PermissionGroup");
    }

    /**
     * Key {@code Job.Import.Plugin.Permission}: {@code Import Jobs}.
     * 
     * @return
     *     {@code Import Jobs}
     */
    public static String Job_Import_Plugin_Permission() {
        return holder.format("Job.Import.Plugin.Permission");
    }

    /**
     * Key {@code Job.Import.Plugin.Permission}: {@code Import Jobs}.
     * 
     * @return
     *     {@code Import Jobs}
     */
    public static Localizable _Job_Import_Plugin_Permission() {
        return new Localizable(holder, "Job.Import.Plugin.Permission");
    }

    /**
     * Key {@code DisplayName}: {@code Job Import Plugin}.
     * 
     * @return
     *     {@code Job Import Plugin}
     */
    public static String DisplayName() {
        return holder.format("DisplayName");
    }

    /**
     * Key {@code DisplayName}: {@code Job Import Plugin}.
     * 
     * @return
     *     {@code Job Import Plugin}
     */
    public static Localizable _DisplayName() {
        return new Localizable(holder, "DisplayName");
    }

    /**
     * Key {@code Job.Import.Plugin.Import.Success.NotReloaded}: {@code

     * SUCCESS - Reload was not performed due to lack of Overall/Administer

     * permissions.}.
     * 
     * @return
     *     {@code SUCCESS - Reload was not performed due to lack of

     *     Overall/Administer permissions.}
     */
    public static String Job_Import_Plugin_Import_Success_NotReloaded() {
        return holder.format("Job.Import.Plugin.Import.Success.NotReloaded");
    }

    /**
     * Key {@code Job.Import.Plugin.Import.Success.NotReloaded}: {@code

     * SUCCESS - Reload was not performed due to lack of Overall/Administer

     * permissions.}.
     * 
     * @return
     *     {@code SUCCESS - Reload was not performed due to lack of

     *     Overall/Administer permissions.}
     */
    public static Localizable _Job_Import_Plugin_Import_Success_NotReloaded() {
        return new Localizable(holder, "Job.Import.Plugin.Import.Success.NotReloaded");
    }

    /**
     * Key {@code Job.Import.Plugin.Import.Failed.Exception}: {@code FAILED -

     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code FAILED - {0}}
     */
    public static String Job_Import_Plugin_Import_Failed_Exception(Object arg0) {
        return holder.format("Job.Import.Plugin.Import.Failed.Exception", arg0);
    }

    /**
     * Key {@code Job.Import.Plugin.Import.Failed.Exception}: {@code FAILED -

     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code FAILED - {0}}
     */
    public static Localizable _Job_Import_Plugin_Import_Failed_Exception(Object arg0) {
        return new Localizable(holder, "Job.Import.Plugin.Import.Failed.Exception", arg0);
    }

    /**
     * Key {@code Job.Import.Plugin.Import.Failed.Duplicate}: {@code FAILED -

     * Duplicate Job Name}.
     * 
     * @return
     *     {@code FAILED - Duplicate Job Name}
     */
    public static String Job_Import_Plugin_Import_Failed_Duplicate() {
        return holder.format("Job.Import.Plugin.Import.Failed.Duplicate");
    }

    /**
     * Key {@code Job.Import.Plugin.Import.Failed.Duplicate}: {@code FAILED -

     * Duplicate Job Name}.
     * 
     * @return
     *     {@code FAILED - Duplicate Job Name}
     */
    public static Localizable _Job_Import_Plugin_Import_Failed_Duplicate() {
        return new Localizable(holder, "Job.Import.Plugin.Import.Failed.Duplicate");
    }

}
