// CHECKSTYLE:OFF

package org.thoughtslive.jenkins.plugins.jira;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Site.emptyCredentialsId}: {@code Credentials is required}.
     * 
     * @return
     *     {@code Credentials is required}
     */
    public static String Site_emptyCredentialsId() {
        return holder.format("Site.emptyCredentialsId");
    }

    /**
     * Key {@code Site.emptyCredentialsId}: {@code Credentials is required}.
     * 
     * @return
     *     {@code Credentials is required}
     */
    public static Localizable _Site_emptyCredentialsId() {
        return new Localizable(holder, "Site.emptyCredentialsId");
    }

    /**
     * Key {@code Site.invalidCredentialsId}: {@code Current credentials does
     * not exists}.
     * 
     * @return
     *     {@code Current credentials does not exists}
     */
    public static String Site_invalidCredentialsId() {
        return holder.format("Site.invalidCredentialsId");
    }

    /**
     * Key {@code Site.invalidCredentialsId}: {@code Current credentials does
     * not exists}.
     * 
     * @return
     *     {@code Current credentials does not exists}
     */
    public static Localizable _Site_invalidCredentialsId() {
        return new Localizable(holder, "Site.invalidCredentialsId");
    }

    /**
     * Key {@code Site.testFail}: {@code Failed login to JIRA: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed login to JIRA: {0}}
     */
    public static String Site_testFail(Object arg0) {
        return holder.format("Site.testFail", arg0);
    }

    /**
     * Key {@code Site.testFail}: {@code Failed login to JIRA: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed login to JIRA: {0}}
     */
    public static Localizable _Site_testFail(Object arg0) {
        return new Localizable(holder, "Site.testFail", arg0);
    }

    /**
     * Key {@code Site.invalidReadTimeout}: {@code Read timeout can''t be
     * less than 100.}.
     * 
     * @return
     *     {@code Read timeout can''t be less than 100.}
     */
    public static String Site_invalidReadTimeout() {
        return holder.format("Site.invalidReadTimeout");
    }

    /**
     * Key {@code Site.invalidReadTimeout}: {@code Read timeout can''t be
     * less than 100.}.
     * 
     * @return
     *     {@code Read timeout can''t be less than 100.}
     */
    public static Localizable _Site_invalidReadTimeout() {
        return new Localizable(holder, "Site.invalidReadTimeout");
    }

    /**
     * Key {@code required}: {@code Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static String required() {
        return holder.format("required");
    }

    /**
     * Key {@code required}: {@code Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static Localizable _required() {
        return new Localizable(holder, "required");
    }

    /**
     * Key {@code Site.testSuccess}: {@code Success: {0} - {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Success: {0} - {1}}
     */
    public static String Site_testSuccess(Object arg0, Object arg1) {
        return holder.format("Site.testSuccess", arg0, arg1);
    }

    /**
     * Key {@code Site.testSuccess}: {@code Success: {0} - {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Success: {0} - {1}}
     */
    public static Localizable _Site_testSuccess(Object arg0, Object arg1) {
        return new Localizable(holder, "Site.testSuccess", arg0, arg1);
    }

    /**
     * Key {@code Site.emptyURL}: {@code URL is required}.
     * 
     * @return
     *     {@code URL is required}
     */
    public static String Site_emptyURL() {
        return holder.format("Site.emptyURL");
    }

    /**
     * Key {@code Site.emptyURL}: {@code URL is required}.
     * 
     * @return
     *     {@code URL is required}
     */
    public static Localizable _Site_emptyURL() {
        return new Localizable(holder, "Site.emptyURL");
    }

    /**
     * Key {@code Site.invalidTimeout}: {@code Timeout can''t be less than
     *  100.}.
     * 
     * @return
     *     {@code Timeout can''t be less than 100.}
     */
    public static String Site_invalidTimeout() {
        return holder.format("Site.invalidTimeout");
    }

    /**
     * Key {@code Site.invalidTimeout}: {@code Timeout can''t be less than
     *  100.}.
     * 
     * @return
     *     {@code Timeout can''t be less than 100.}
     */
    public static Localizable _Site_invalidTimeout() {
        return new Localizable(holder, "Site.invalidTimeout");
    }

}
