// CHECKSTYLE:OFF

package org.jenkinsci.plugins.jdk_tool;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code JDKInstaller.DescriptorImpl.doCheckAcceptLicense}: {@code

     * You must agree to the license to download the JDK.}.
     * 
     * @return
     *     {@code You must agree to the license to download the JDK.}
     */
    public static String JDKInstaller_DescriptorImpl_doCheckAcceptLicense() {
        return holder.format("JDKInstaller.DescriptorImpl.doCheckAcceptLicense");
    }

    /**
     * Key {@code JDKInstaller.DescriptorImpl.doCheckAcceptLicense}: {@code

     * You must agree to the license to download the JDK.}.
     * 
     * @return
     *     {@code You must agree to the license to download the JDK.}
     */
    public static Localizable _JDKInstaller_DescriptorImpl_doCheckAcceptLicense() {
        return new Localizable(holder, "JDKInstaller.DescriptorImpl.doCheckAcceptLicense");
    }

    /**
     * Key {@code JDKInstaller.UnableToInstallUntilLicenseAccepted}: {@code

     * Unable to auto-install JDK until the license is accepted.}.
     * 
     * @return
     *     {@code Unable to auto-install JDK until the license is accepted.}
     */
    public static String JDKInstaller_UnableToInstallUntilLicenseAccepted() {
        return holder.format("JDKInstaller.UnableToInstallUntilLicenseAccepted");
    }

    /**
     * Key {@code JDKInstaller.UnableToInstallUntilLicenseAccepted}: {@code

     * Unable to auto-install JDK until the license is accepted.}.
     * 
     * @return
     *     {@code Unable to auto-install JDK until the license is accepted.}
     */
    public static Localizable _JDKInstaller_UnableToInstallUntilLicenseAccepted() {
        return new Localizable(holder, "JDKInstaller.UnableToInstallUntilLicenseAccepted");
    }

    /**
     * Key {@code JDKInstaller.DescriptorImpl.doCheckId}: {@code Define JDK

     * ID}.
     * 
     * @return
     *     {@code Define JDK ID}
     */
    public static String JDKInstaller_DescriptorImpl_doCheckId() {
        return holder.format("JDKInstaller.DescriptorImpl.doCheckId");
    }

    /**
     * Key {@code JDKInstaller.DescriptorImpl.doCheckId}: {@code Define JDK

     * ID}.
     * 
     * @return
     *     {@code Define JDK ID}
     */
    public static Localizable _JDKInstaller_DescriptorImpl_doCheckId() {
        return new Localizable(holder, "JDKInstaller.DescriptorImpl.doCheckId");
    }

    /**
     * Key {@code JDKInstaller.FailedToInstallJDK}: {@code Failed to install

     * JDK. Exit code={0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to install JDK. Exit code={0}}
     */
    public static String JDKInstaller_FailedToInstallJDK(Object arg0) {
        return holder.format("JDKInstaller.FailedToInstallJDK", arg0);
    }

    /**
     * Key {@code JDKInstaller.FailedToInstallJDK}: {@code Failed to install

     * JDK. Exit code={0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to install JDK. Exit code={0}}
     */
    public static Localizable _JDKInstaller_FailedToInstallJDK(Object arg0) {
        return new Localizable(holder, "JDKInstaller.FailedToInstallJDK", arg0);
    }

    /**
     * Key {@code JDKInstaller.RequireOracleAccount}: {@code Installing JDK

     * requires Oracle account. <a href="{0}" target="_new">Please enter your

     * username/password</a>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Installing JDK requires Oracle account. <a href="{0}"

     *     target="_new">Please enter your username/password</a>}
     */
    public static String JDKInstaller_RequireOracleAccount(Object arg0) {
        return holder.format("JDKInstaller.RequireOracleAccount", arg0);
    }

    /**
     * Key {@code JDKInstaller.RequireOracleAccount}: {@code Installing JDK

     * requires Oracle account. <a href="{0}" target="_new">Please enter your

     * username/password</a>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Installing JDK requires Oracle account. <a href="{0}"

     *     target="_new">Please enter your username/password</a>}
     */
    public static Localizable _JDKInstaller_RequireOracleAccount(Object arg0) {
        return new Localizable(holder, "JDKInstaller.RequireOracleAccount", arg0);
    }

    /**
     * Key {@code JDKInstaller.DescriptorImpl.displayName}: {@code Install

     * Oracle Java SE Development Kit from the website}.
     * 
     * @return
     *     {@code Install Oracle Java SE Development Kit from the website}
     */
    public static String JDKInstaller_DescriptorImpl_displayName() {
        return holder.format("JDKInstaller.DescriptorImpl.displayName");
    }

    /**
     * Key {@code JDKInstaller.DescriptorImpl.displayName}: {@code Install

     * Oracle Java SE Development Kit from the website}.
     * 
     * @return
     *     {@code Install Oracle Java SE Development Kit from the website}
     */
    public static Localizable _JDKInstaller_DescriptorImpl_displayName() {
        return new Localizable(holder, "JDKInstaller.DescriptorImpl.displayName");
    }

}
