/*
 * Decompiled with CFR 0.152.
 */
package hudson.security.captcha;

import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.DefaultManageableImageCaptchaService;
import hudson.Extension;
import hudson.security.captcha.CaptchaSupport;
import hudson.security.captcha.CaptchaSupportDescriptor;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.kohsuke.stapler.DataBoundConstructor;

public class JcaptchaSupport
extends CaptchaSupport {
    private static final Logger LOGGER = Logger.getLogger(JcaptchaSupport.class.getName());

    @DataBoundConstructor
    public JcaptchaSupport() {
    }

    public boolean validateCaptcha(String id, String text) {
        try {
            Boolean b = CaptchaService.INSTANCE.validateResponseForID(id, (Object)text);
            return b != null && b != false;
        }
        catch (CaptchaServiceException e) {
            LOGGER.log(Level.INFO, "Captcha validation had a problem", e);
            return false;
        }
    }

    public void generateImage(String id, OutputStream ios) throws IOException {
        ImageIO.write((RenderedImage)CaptchaService.INSTANCE.getImageChallengeForID(id), "PNG", ios);
    }

    private static final class CaptchaService {
        private static final DefaultManageableImageCaptchaService INSTANCE = new DefaultManageableImageCaptchaService();

        private CaptchaService() {
        }
    }

    @Extension
    public static class DescriptorImpl
    extends CaptchaSupportDescriptor {
        public String getDisplayName() {
            return "JCaptcha";
        }
    }
}

