/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.javadoc.Messages;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class JavadocArchiver
extends Recorder
implements SimpleBuildStep {
    static final String JAVADOC_ICON = "symbol-duke-icon-solid plugin-oss-symbols-api";
    private final String javadocDir;
    private final boolean keepAll;

    @DataBoundConstructor
    public JavadocArchiver(String javadocDir, boolean keepAll) {
        this.javadocDir = javadocDir;
        this.keepAll = keepAll;
    }

    public String getJavadocDir() {
        return this.javadocDir;
    }

    public boolean isKeepAll() {
        return this.keepAll;
    }

    private static File getJavadocDir(Job<?, ?> project) {
        return new File(project.getRootDir(), "javadoc");
    }

    private static File getJavadocDir(Run run) {
        return new File(run.getRootDir(), "javadoc");
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        listener.getLogger().println(Messages.JavadocArchiver_Publishing());
        EnvVars env = build.getEnvironment(listener);
        FilePath javadoc = workspace.child(env.expand(this.javadocDir));
        FilePath target = new FilePath(this.keepAll ? JavadocArchiver.getJavadocDir(build) : JavadocArchiver.getJavadocDir(build.getParent()));
        try {
            if (javadoc.copyRecursiveTo("**/*", target) == 0) {
                Result result = build.getResult();
                if (result == null || result.isBetterOrEqualTo(Result.UNSTABLE)) {
                    listener.error(Messages.JavadocArchiver_NoMatchFound(javadoc, javadoc.validateAntFileMask("**/*")));
                }
                build.setResult(Result.FAILURE);
                return;
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError(Messages.JavadocArchiver_UnableToCopy(javadoc, target)));
            build.setResult(Result.FAILURE);
            return;
        }
        build.addAction((Action)new JavadocBuildAction());
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public static class JavadocBuildAction
    extends BaseJavadocAction
    implements RunAction2,
    SimpleBuildStep.LastBuildAction {
        private transient Run<?, ?> build;

        public JavadocBuildAction() {
        }

        @Deprecated
        public JavadocBuildAction(AbstractBuild<?, ?> build) {
            this.build = build;
        }

        public void onAttached(Run<?, ?> r) {
            this.build = r;
        }

        public void onLoad(Run<?, ?> r) {
            this.build = r;
        }

        @Override
        protected String getTitle() {
            return this.build.getDisplayName() + " javadoc";
        }

        @Override
        protected File dir() {
            return JavadocArchiver.getJavadocDir(this.build);
        }

        public Collection<? extends Action> getProjectActions() {
            return Collections.singleton(new JavadocAction(this.build.getParent()));
        }
    }

    @Extension
    @Symbol(value={"javadoc"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return Messages.JavadocArchiver_DisplayName();
        }

        public FormValidation doCheckJavadocDir(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException, ServletException {
            if (project == null) {
                return FormValidation.ok();
            }
            FilePath ws = project.getSomeWorkspace();
            return ws != null ? ws.validateRelativeDirectory(value) : FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }

    public static class JavadocAction
    extends BaseJavadocAction
    implements ProminentProjectAction {
        private final Job<?, ?> project;

        @Deprecated
        public JavadocAction(AbstractItem project) {
            this((Job)project);
        }

        public JavadocAction(Job<?, ?> project) {
            this.project = project;
        }

        @Override
        protected File dir() {
            File javadocDir;
            Run run = this.project.getLastSuccessfulBuild();
            if (run != null && (javadocDir = JavadocArchiver.getJavadocDir(run)).exists()) {
                return javadocDir;
            }
            return JavadocArchiver.getJavadocDir(this.project);
        }

        @Override
        protected String getTitle() {
            return this.project.getDisplayName() + " javadoc";
        }
    }

    protected static abstract class BaseJavadocAction
    implements Action {
        protected BaseJavadocAction() {
        }

        public String getUrlName() {
            return "javadoc";
        }

        public String getDisplayName() {
            File dir = this.dir();
            if (dir != null && new File(dir, "help-doc.html").exists()) {
                return Messages.JavadocArchiver_DisplayName_Javadoc();
            }
            return Messages.JavadocArchiver_DisplayName_Generic();
        }

        public String getIconFileName() {
            File dir = this.dir();
            if (dir != null && dir.exists()) {
                return JavadocArchiver.JAVADOC_ICON;
            }
            return null;
        }

        public void doDynamic(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
            File basedir = this.dir();
            DirectoryBrowserSupport dbs = new DirectoryBrowserSupport((ModelObject)this, new FilePath(basedir), this.getTitle(), JavadocArchiver.JAVADOC_ICON, false);
            String index = this.alternativeIndexFile(basedir);
            if (index != null) {
                dbs.setIndexFileName(index);
            }
            dbs.generateResponse(req, rsp, (Object)this);
        }

        @CheckForNull
        private String alternativeIndexFile(File basedir) {
            boolean useFrameless = Boolean.parseBoolean(System.getProperty(JavadocArchiver.class.getName() + ".useFramelessIndex", "true"));
            if (!useFrameless) {
                return null;
            }
            if (new File(basedir, "overview-tree.html").exists()) {
                return "overview-tree.html";
            }
            return null;
        }

        protected abstract String getTitle();

        protected abstract File dir();
    }
}

