/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.ivy.AbstractIvyProject;
import hudson.ivy.IvyAggregatedReport;
import hudson.ivy.IvyModule;
import hudson.ivy.IvyModuleSetBuild;
import hudson.ivy.IvyReporter;
import hudson.ivy.Messages;
import hudson.ivy.ModuleName;
import hudson.ivy.builder.AntIvyBuilderType;
import hudson.ivy.builder.IvyBuilderType;
import hudson.ivy.builder.NAntIvyBuilderType;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ItemGroupMixIn;
import hudson.model.Job;
import hudson.model.PersistentDescriptor;
import hudson.model.Queue;
import hudson.model.ResourceActivity;
import hudson.model.SCMedItem;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.queue.CauseOfBlockage;
import hudson.search.CollectionSearchIndex;
import hudson.search.SearchIndex;
import hudson.search.SearchIndexBuilder;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrappers;
import hudson.tasks.Publisher;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.util.CopyOnWriteMap;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.verb.POST;

public final class IvyModuleSet
extends AbstractIvyProject<IvyModuleSet, IvyModuleSetBuild>
implements TopLevelItem,
ItemGroup<IvyModule>,
SCMedItem,
Saveable,
BuildableItemWithBuildWrappers {
    transient Map<ModuleName, IvyModule> modules = new CopyOnWriteMap.Tree();
    transient List<IvyModule> sortedActiveModules;
    private String ivyFilePattern;
    private String ivyFileExcludesPattern;
    private String targets;
    private String ivyBranch;
    private String relativePathToDescriptorFromModuleRoot;
    private String ivySettingsFile;
    private String settings;
    private String ivySettingsPropertyFiles;
    private IvyBuilderType ivyBuilderType;
    private String antName;
    private String antOpts;
    private String buildFile;
    private String antProperties;
    private boolean aggregatorStyleBuild = true;
    private boolean incrementalBuild = false;
    private String changedModulesProperty;
    private boolean ignoreUpstreamChanges = false;
    private Boolean allowedToTriggerDownstream = true;
    private boolean useUpstreamParameters = false;
    private boolean archivingDisabled = false;
    private DescribableList<Publisher, Descriptor<Publisher>> publishers = new DescribableList((Saveable)this);
    private DescribableList<BuildWrapper, Descriptor<BuildWrapper>> buildWrappers = new DescribableList((Saveable)this);
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @Override
    public boolean isUseUpstreamParameters() {
        return this.useUpstreamParameters;
    }

    public void setUseUpstreamParameters(boolean useUpstreamParameters) {
        this.useUpstreamParameters = useUpstreamParameters;
    }

    public IvyModuleSet(String name) {
        this((ItemGroup)Jenkins.get(), name);
    }

    public IvyModuleSet(ItemGroup parent, String name) {
        super(parent, name);
    }

    public String getUrlChildPrefix() {
        return ".";
    }

    public Collection<IvyModule> getItems() {
        return this.modules.values();
    }

    @Exported
    public Collection<IvyModule> getModules() {
        return this.getItems();
    }

    public IvyModule getItem(String name) {
        try {
            return this.modules.get(ModuleName.fromString(name));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public IvyModule getModule(String name) {
        return this.getItem(name);
    }

    public String getSettings() {
        return this.settings;
    }

    protected void updateTransientActions() {
        super.updateTransientActions();
    }

    @Override
    protected List<Action> createTransientActions() {
        List<Action> r = super.createTransientActions();
        for (IvyModule module : this.modules.values()) {
            module.updateTransientActions();
        }
        if (this.publishers != null) {
            for (BuildStep step : this.publishers) {
                r.addAll(step.getProjectActions((AbstractProject)this));
            }
        }
        if (this.buildWrappers != null) {
            for (BuildStep step : this.buildWrappers) {
                r.addAll(step.getProjectActions((AbstractProject)this));
            }
        }
        return r;
    }

    @Override
    protected void addTransientActionsFromBuild(IvyModuleSetBuild build, List<Action> collection, Set<Class> added) {
        if (build == null) {
            return;
        }
        for (Action a : build.getActions()) {
            if (!(a instanceof IvyAggregatedReport) || !added.add(a.getClass())) continue;
            collection.add(((IvyAggregatedReport)a).getProjectAction(this));
        }
        List<IvyReporter> list = build.projectActionReporters;
        if (list == null) {
            return;
        }
        for (IvyReporter step : list) {
            Action a;
            if (!added.add(step.getClass()) || (a = step.getAggregatedProjectAction(this)) == null) continue;
            collection.add(a);
        }
    }

    void onModuleDeleted(IvyModule module) {
        this.modules.remove(module.getModuleName());
    }

    public boolean hasDisabledModule() {
        for (IvyModule m : this.modules.values()) {
            if (!m.isDisabled()) continue;
            return true;
        }
        return false;
    }

    public List<IvyModule> getDisabledModules(boolean disabled) {
        if (!disabled && this.sortedActiveModules != null) {
            return this.sortedActiveModules;
        }
        ArrayList<IvyModule> r = new ArrayList<IvyModule>();
        for (IvyModule m : this.modules.values()) {
            if (m.isDisabled() != disabled) continue;
            r.add(m);
        }
        return r;
    }

    public boolean isIncrementalBuild() {
        return this.incrementalBuild;
    }

    public String getChangedModulesProperty() {
        return this.changedModulesProperty;
    }

    public boolean isAggregatorStyleBuild() {
        return this.aggregatorStyleBuild;
    }

    public boolean ignoreUpstreamChanges() {
        return this.ignoreUpstreamChanges;
    }

    public boolean isAllowedToTriggerDownstream() {
        return this.allowedToTriggerDownstream;
    }

    public void setAllowedToTriggerDownstream(boolean allowedToTriggerDownstream) {
        this.allowedToTriggerDownstream = allowedToTriggerDownstream;
    }

    public boolean isArchivingDisabled() {
        return this.archivingDisabled;
    }

    public void setIncrementalBuild(boolean incrementalBuild) {
        this.incrementalBuild = incrementalBuild;
    }

    public String getIvyFilePattern() {
        return this.ivyFilePattern;
    }

    public void setIvyFilePattern(String ivyFilePattern) {
        this.ivyFilePattern = ivyFilePattern;
    }

    public String getIvyFileExcludesPattern() {
        return this.ivyFileExcludesPattern;
    }

    public void setIvyFileExcludesPattern(String ivyFileExcludesPattern) {
        this.ivyFileExcludesPattern = ivyFileExcludesPattern;
    }

    public String getIvySettingsFile() {
        return this.ivySettingsFile;
    }

    public void setIvySettingsFile(String ivySettingsFile) {
        this.ivySettingsFile = ivySettingsFile;
    }

    public String getIvySettingsPropertyFiles() {
        return this.ivySettingsPropertyFiles;
    }

    public void setIvySettingsPropertyFiles(String ivySettingsPropertyFiles) {
        this.ivySettingsPropertyFiles = ivySettingsPropertyFiles;
    }

    public String getIvyBranch() {
        return this.ivyBranch;
    }

    public void setIvyBranch(String ivyBranch) {
        this.ivyBranch = ivyBranch;
    }

    public IvyBuilderType getIvyBuilderType() {
        return this.ivyBuilderType;
    }

    public void setAggregatorStyleBuild(boolean aggregatorStyleBuild) {
        this.aggregatorStyleBuild = aggregatorStyleBuild;
    }

    public void setIgnoreUpstreamChanges(boolean ignoreUpstreamChanges) {
        this.ignoreUpstreamChanges = ignoreUpstreamChanges;
    }

    public void setIsArchivingDisabled(boolean archivingDisabled) {
        this.archivingDisabled = archivingDisabled;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getModulePublishers() {
        return this.aggregatorStyleBuild ? new DescribableList((Saveable)this) : this.publishers;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishers() {
        return this.publishers;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList() {
        return this.publishers;
    }

    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappersList() {
        return this.buildWrappers;
    }

    @Deprecated
    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappers() {
        return this.buildWrappers;
    }

    public Object getDynamic(String token, StaplerRequest2 req, StaplerResponse2 rsp) {
        if (ModuleName.isValid(token)) {
            return this.getModule(token);
        }
        return super.getDynamic(token, req, rsp);
    }

    public File getRootDirFor(IvyModule child) {
        return new File(this.getModulesDir(), child.getModuleName().toFileSystemName());
    }

    public void onRenamed(IvyModule item, String oldName, String newName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void onDeleted(IvyModule item) throws IOException {
    }

    public Collection<Job> getAllJobs() {
        HashSet<IvyModule> jobs = new HashSet<IvyModule>(this.getItems());
        jobs.add((IvyModule)((Object)this));
        return jobs;
    }

    protected Class<IvyModuleSetBuild> getBuildClass() {
        return IvyModuleSetBuild.class;
    }

    protected SearchIndexBuilder makeSearchIndex() {
        return super.makeSearchIndex().add((SearchIndex)new CollectionSearchIndex<IvyModule>(){

            protected IvyModule get(String key) {
                for (IvyModule m : IvyModuleSet.this.modules.values()) {
                    if (!m.getDisplayName().equals(key)) continue;
                    return m;
                }
                return null;
            }

            protected Collection<IvyModule> all() {
                return IvyModuleSet.this.modules.values();
            }

            protected String getName(IvyModule o) {
                return o.getName();
            }
        });
    }

    public boolean isFingerprintConfigured() {
        return true;
    }

    public synchronized void save() throws IOException {
        super.save();
        if (!this.isAggregatorStyleBuild()) {
            for (IvyModule module : this.getModules()) {
                module.save();
            }
        }
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        this.modules = Collections.emptyMap();
        super.onLoad(parent, name);
        this.modules = ItemGroupMixIn.loadChildren((ItemGroup)this, (File)this.getModulesDir(), IvyModule::getModuleName);
        if (this.publishers == null) {
            this.publishers = new DescribableList((Saveable)this);
        }
        this.publishers.setOwner((Saveable)this);
        if (this.buildWrappers == null) {
            this.buildWrappers = new DescribableList((Saveable)this);
            this.buildWrappers.setOwner((Saveable)this);
        }
        this.updateTransientActions();
    }

    private File getModulesDir() {
        return new File(this.getRootDir(), "modules");
    }

    public synchronized int assignBuildNumber() throws IOException {
        this.updateNextBuildNumber();
        return super.assignBuildNumber();
    }

    public void logRotate() throws IOException, InterruptedException {
        super.logRotate();
        for (IvyModule m : this.modules.values()) {
            m.logRotate();
        }
    }

    void updateNextBuildNumber() throws IOException {
        int next = this.nextBuildNumber;
        for (IvyModule m : this.modules.values()) {
            next = Math.max(next, m.getNextBuildNumber());
        }
        if (this.nextBuildNumber != next) {
            this.nextBuildNumber = next;
            this.saveNextBuildNumber();
        }
    }

    protected void buildDependencyGraph(DependencyGraph graph) {
        this.publishers.buildDependencyGraph((AbstractProject)this, graph);
        this.buildWrappers.buildDependencyGraph((AbstractProject)this, graph);
    }

    protected Set<ResourceActivity> getResourceActivities() {
        HashSet<ResourceActivity> activities = new HashSet<ResourceActivity>();
        activities.addAll(super.getResourceActivities());
        activities.addAll(Util.filter(this.publishers, ResourceActivity.class));
        activities.addAll(Util.filter(this.buildWrappers, ResourceActivity.class));
        return activities;
    }

    public CauseOfBlockage getCauseOfBlockage() {
        CauseOfBlockage cob = super.getCauseOfBlockage();
        if (cob != null) {
            return cob;
        }
        for (IvyModule module : this.modules.values()) {
            if (!module.isBuilding() && !module.isInQueue()) continue;
            return new BecauseOfModuleBuildInProgress(module);
        }
        return null;
    }

    public AbstractProject<?, ?> asProject() {
        return this;
    }

    public String getRelativePathToDescriptorFromModuleRoot() {
        return this.relativePathToDescriptorFromModuleRoot;
    }

    public void setRelativePathToDescriptorFromModuleRoot(String relativePathToDescriptorFromModuleRoot) {
        this.relativePathToDescriptorFromModuleRoot = relativePathToDescriptorFromModuleRoot;
    }

    public List<Queue.Item> getQueueItems() {
        ArrayList<Queue.Item> r = new ArrayList<Queue.Item>();
        for (Queue.Item item : Jenkins.get().getQueue().getItems()) {
            Queue.Task t = item.task;
            if ((!(t instanceof IvyModule) || ((IvyModule)t).getParent() != this) && t != this) continue;
            r.add(item);
        }
        return r;
    }

    protected void submit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        JSONObject json = req.getSubmittedForm();
        this.ignoreUpstreamChanges = !json.has("triggerByDependency");
        this.allowedToTriggerDownstream = json.has("allowedToTriggerDownstream");
        this.useUpstreamParameters = json.has("useUpstreamParameters");
        this.ivyFilePattern = Util.fixEmptyAndTrim((String)json.getString("ivyFilePattern"));
        this.ivyFileExcludesPattern = Util.fixEmptyAndTrim((String)json.getString("ivyFileExcludesPattern"));
        this.ivySettingsFile = Util.fixEmptyAndTrim((String)json.getString("ivySettingsFile"));
        this.settings = Util.fixEmptyAndTrim((String)json.getString("settings"));
        this.ivySettingsPropertyFiles = Util.fixEmptyAndTrim((String)json.getString("ivySettingsPropertyFiles"));
        this.ivyBranch = Util.fixEmptyAndTrim((String)json.getString("ivyBranch"));
        this.relativePathToDescriptorFromModuleRoot = Util.fixEmptyAndTrim((String)json.getString("relativePathToDescriptorFromModuleRoot"));
        JSONObject ivyBuilderTypeJson = json.getJSONObject("ivyBuilderType");
        try {
            this.ivyBuilderType = (IvyBuilderType)req.bindJSON(Class.forName(ivyBuilderTypeJson.getString("stapler-class")), ivyBuilderTypeJson);
        }
        catch (ClassNotFoundException e) {
            throw new Descriptor.FormException("Error creating specified builder type.", (Throwable)e, "ivyBuilderType");
        }
        this.aggregatorStyleBuild = !req.hasParameter("perModuleBuild");
        this.incrementalBuild = req.hasParameter("incrementalBuild");
        if (this.incrementalBuild) {
            this.changedModulesProperty = Util.fixEmptyAndTrim((String)json.getJSONObject("incrementalBuild").getString("changedModulesProperty"));
        }
        this.publishers.rebuildHetero(req, json, (Collection)Publisher.all(), "publisher");
        this.buildWrappers.rebuild(req, json, BuildWrappers.getFor((AbstractProject)this));
        if (!this.isAggregatorStyleBuild()) {
            for (IvyModule module : this.getModules()) {
                module.getBuildWrappersList().rebuild(req, json, BuildWrappers.getFor((AbstractProject)module));
            }
        }
    }

    public Class<? extends AbstractProject> getModuleClass() {
        return IvyModule.class;
    }

    public AbstractTestResultAction<?> getTestResultAction() {
        IvyModuleSetBuild b = (IvyModuleSetBuild)this.getLastBuild();
        return b != null ? (AbstractTestResultAction)b.getAction(AbstractTestResultAction.class) : null;
    }

    @POST
    public void doDoDeleteAllDisabledModules(StaplerResponse2 rsp) throws IOException, InterruptedException {
        this.checkPermission(DELETE);
        for (IvyModule m : this.getDisabledModules(true)) {
            m.delete();
        }
        rsp.sendRedirect2(".");
    }

    public FormValidation doCheckFileInWorkspace(@QueryParameter String value) throws IOException, ServletException {
        FilePath ws;
        IvyModuleSetBuild lb = (IvyModuleSetBuild)this.getLastBuild();
        if (lb != null && (ws = lb.getModuleRoot()) != null) {
            return ws.validateRelativePath(value, true, true);
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckIvySettingsFile(@QueryParameter String value) throws IOException, ServletException {
        FilePath ws;
        String v = Util.fixEmpty((String)value);
        if (v == null || v.length() == 0) {
            return FormValidation.ok();
        }
        IvyModuleSetBuild lb = (IvyModuleSetBuild)this.getLastBuild();
        if (lb != null && (ws = lb.getWorkspace()) != null) {
            if (v.startsWith("/") || v.startsWith("\\") || v.matches("^\\w\\:\\\\.*")) {
                return this.validateAbsolutePath(ws, v);
            }
            return ws.validateRelativePath(v, true, true);
        }
        return FormValidation.ok();
    }

    private FormValidation validateAbsolutePath(FilePath ws, String path) throws IOException {
        try {
            if (ws.child(path).exists()) {
                return FormValidation.ok();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return FormValidation.error((String)("Error reading ivy settings file: " + path));
    }

    public ArrayList<Descriptor<IvyBuilderType>> getBuilderTypeDescriptors() {
        ArrayList<Descriptor<IvyBuilderType>> buildTypeDescriptors = new ArrayList<Descriptor<IvyBuilderType>>();
        buildTypeDescriptors.add(Jenkins.get().getDescriptor(AntIvyBuilderType.class));
        if (Jenkins.get().getPlugin("nant") != null) {
            buildTypeDescriptors.add((Descriptor<IvyBuilderType>)Jenkins.get().getDescriptor(NAntIvyBuilderType.class));
        }
        return buildTypeDescriptors;
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    protected Object readResolve() {
        if (this.ivyBuilderType == null) {
            this.ivyBuilderType = new AntIvyBuilderType(this.antName, this.buildFile, this.targets, this.antProperties, this.antOpts);
            this.antName = null;
            this.buildFile = null;
            this.targets = null;
            this.antProperties = null;
            this.antOpts = null;
        }
        if (this.allowedToTriggerDownstream == null) {
            this.allowedToTriggerDownstream = true;
        }
        return this;
    }

    public static class BecauseOfModuleBuildInProgress
    extends CauseOfBlockage {
        public final IvyModule module;

        public BecauseOfModuleBuildInProgress(IvyModule module) {
            this.module = module;
        }

        public String getShortDescription() {
            return Messages.IvyModuleSet_ModuleBuildInProgress(this.module.getName());
        }
    }

    public static final class DescriptorImpl
    extends AbstractProject.AbstractProjectDescriptor
    implements PersistentDescriptor {
        private String globalAntOpts;

        public String getGlobalAntOpts() {
            return this.globalAntOpts;
        }

        @DataBoundSetter
        public void setGlobalAntOpts(String globalAntOpts) {
            this.globalAntOpts = Util.fixEmptyAndTrim((String)globalAntOpts);
            this.save();
        }

        public ListBoxModel doFillSettingsItems(@AncestorInPath ItemGroup context) {
            List configsInContext = ConfigFiles.getConfigsInContext((ItemGroup)context, null);
            ListBoxModel lb = new ListBoxModel();
            lb.add("please select", "");
            for (Config config : configsInContext) {
                lb.add(config.name, config.id);
            }
            return lb;
        }

        public String getDisplayName() {
            return Messages.IvyModuleSet_DisplayName();
        }

        public TopLevelItem newInstance(ItemGroup parent, String name) {
            return new IvyModuleSet(parent, name);
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) {
            req.bindJSON((Object)this, json);
            this.save();
            return true;
        }
    }
}

