/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.BulkChange;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.ivy.IvyMessageImpl;
import hudson.ivy.IvyThresholdDependency;
import hudson.ivy.Messages;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.PersistentDescriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Saveable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.DependencyDeclarer;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class IvyBuildTrigger
extends Notifier
implements DependencyDeclarer {
    private static final String BACKUP_IVY_FILE_NAME = "ivy.xml";
    private static final String BACKUP_IVY_PROPERTIES_NAME = "ivy.properties";
    private static final Logger LOGGER = Logger.getLogger(IvyBuildTrigger.class.getName());
    private final String ivyFile;
    private final String ivyProperties;
    private final String ivyConfName;
    private final boolean triggerWhenUnstable;
    private final boolean useUpstreamParameters;
    private transient long lastmodified = 0L;
    private transient ModuleDescriptor moduleDescriptor;
    private transient VersionMatcher versionMatcher;
    @Extension
    public static final DescriptorImpl DESCRIPTOR;

    @DataBoundConstructor
    public IvyBuildTrigger(String ivyFile, String ivyConfName, String ivyPropertiesFile, boolean triggerWhenUnstable, boolean useUpstreamParameters) {
        this.ivyFile = ivyFile;
        this.ivyConfName = ivyConfName;
        this.ivyProperties = ivyPropertiesFile;
        this.triggerWhenUnstable = triggerWhenUnstable;
        this.useUpstreamParameters = useUpstreamParameters;
    }

    @Deprecated
    public IvyBuildTrigger(String ivyFile, String ivyConfName) {
        this(ivyFile, ivyConfName, null, false, false);
    }

    public String getIvyPropertiesFile() {
        return this.ivyProperties;
    }

    public String getIvyFile() {
        return this.ivyFile;
    }

    public String getIvyConfName() {
        return this.ivyConfName;
    }

    private IvyConfiguration getIvyConfiguration() {
        IvyConfiguration conf = null;
        if (this.ivyConfName != null) {
            for (IvyConfiguration i : DESCRIPTOR.getConfigurations()) {
                if (!i.getName().equals(this.ivyConfName)) continue;
                conf = i;
                break;
            }
        }
        return conf;
    }

    public boolean isTriggerWhenUnstable() {
        return this.triggerWhenUnstable;
    }

    public boolean isUseUpstreamParameters() {
        return this.useUpstreamParameters;
    }

    public Ivy getIvy(File localFilePath, String propertyFile) {
        Message.setDefaultLogger((MessageLogger)new IvyMessageImpl());
        IvyConfiguration ivyConf = this.getIvyConfiguration();
        try {
            IvySettings ivySettings = new IvySettings();
            if (propertyFile != null) {
                File f = new File(localFilePath, propertyFile);
                ivySettings.loadProperties(f);
                LOGGER.log(Level.INFO, "Configured Ivy using custom properties " + String.valueOf(f));
            }
            if (ivyConf != null) {
                ivySettings.load(new File(ivyConf.getIvyConfPath()));
                LOGGER.log(Level.INFO, "Configured Ivy using custom settings " + ivyConf.getIvyConfPath());
            } else {
                ivySettings.loadDefault();
                LOGGER.log(Level.INFO, "Configured Ivy using default 2.1 settings");
            }
            return Ivy.newInstance((IvySettings)ivySettings);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while reading the default Ivy 2.1 settings: " + e.getMessage(), e);
            return null;
        }
    }

    private synchronized ModuleDescriptor getModuleDescriptor(AbstractProject p) {
        if (this.moduleDescriptor == null) {
            if (p.getLastBuiltOn() != null && p.getLastBuiltOn().getChannel() != null) {
                AbstractBuild ab = p.getSomeBuildWithWorkspace();
                this.moduleDescriptor = this.recomputeModuleDescriptor(ab);
            } else {
                LOGGER.warning("Node is offline for " + p.getName() + ", using project to get Module Descriptor");
                this.moduleDescriptor = this.recomputeModuleDescriptor(p);
            }
        }
        return this.moduleDescriptor;
    }

    private boolean copyFileFromWorkspaceIfNecessary(FilePath workspace, String fileToCopy, File localFile, String localDestFile) throws IOException, InterruptedException {
        boolean copied = false;
        if (workspace != null) {
            FilePath f = workspace.child(fileToCopy);
            FilePath backupCopy = new FilePath(localFile).child(localDestFile);
            long flastModified = f.lastModified();
            if (flastModified == 0L) {
                throw new FileNotFoundException("Can't stat file " + String.valueOf(f));
            }
            if (flastModified > this.lastmodified) {
                f.copyTo(backupCopy);
                localFile.setLastModified(flastModified);
                copied = true;
                LOGGER.info("Copied the workspace file " + fileToCopy + " to backup " + String.valueOf(localFile.getCanonicalFile()) + "/" + localDestFile);
            }
        }
        return copied;
    }

    private synchronized ModuleDescriptor recomputeModuleDescriptor(AbstractProject b) {
        File fivyF;
        Ivy ivy;
        LOGGER.fine("Recomputing Moduledescriptor for Project " + b.getFullDisplayName() + " using backup files");
        File destDir = b.getRootDir();
        String propertyFileToLoadIntoIvy = null;
        String propertyFile = this.getIvyPropertiesFile();
        File ivyP = new File(destDir, BACKUP_IVY_PROPERTIES_NAME);
        if (propertyFile != null && !propertyFile.trim().isEmpty() && ivyP.canRead()) {
            propertyFileToLoadIntoIvy = BACKUP_IVY_PROPERTIES_NAME;
        }
        if ((ivy = this.getIvy(destDir, propertyFileToLoadIntoIvy)) == null) {
            return null;
        }
        this.versionMatcher = ivy.getSettings().getVersionMatcher();
        String ivyDesc = this.getIvyFile();
        File ivyF = null;
        if (ivyDesc != null && !ivyDesc.trim().isEmpty()) {
            ivyF = new File(destDir, BACKUP_IVY_FILE_NAME);
        }
        if ((fivyF = ivyF) == null || !fivyF.canRead()) {
            LOGGER.log(Level.WARNING, "Cannot read ivy file backup...removing ModuleDescriptor");
            return null;
        }
        if (this.moduleDescriptor == null || fivyF.lastModified() > this.lastmodified) {
            this.lastmodified = fivyF.lastModified();
            return (ModuleDescriptor)ivy.execute(new Ivy.IvyCallback(){
                final /* synthetic */ IvyBuildTrigger this$0;
                {
                    this.this$0 = this$0;
                }

                public Object doInIvyContext(Ivy ivy, IvyContext context) {
                    try {
                        return ModuleDescriptorParserRegistry.getInstance().parseDescriptor((ParserSettings)ivy.getSettings(), fivyF.toURI().toURL(), ivy.getSettings().doValidate());
                    }
                    catch (MalformedURLException e) {
                        LOGGER.log(Level.WARNING, "The URL is malformed : " + String.valueOf(fivyF), e);
                        return null;
                    }
                    catch (ParseException e) {
                        LOGGER.log(Level.WARNING, "Parsing error while reading the ivy file " + String.valueOf(fivyF), e);
                        return null;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "I/O error while reading the ivy file " + String.valueOf(fivyF), e);
                        return null;
                    }
                }
            });
        }
        return null;
    }

    private synchronized ModuleDescriptor recomputeModuleDescriptor(AbstractBuild<?, ?> b) {
        File fivyF;
        File ivyF;
        Ivy ivy;
        block14: {
            String propertyFileToLoadIntoIvy;
            File destDir;
            block13: {
                if (b == null) {
                    return null;
                }
                LOGGER.fine("Recomputing Moduledescriptor for Project " + b.getProject().getFullDisplayName());
                destDir = b.getProject().getRootDir();
                propertyFileToLoadIntoIvy = null;
                String propertyFile = this.getIvyPropertiesFile();
                if (propertyFile != null && !propertyFile.trim().isEmpty()) {
                    try {
                        this.copyFileFromWorkspaceIfNecessary(b.getWorkspace(), propertyFile, destDir, BACKUP_IVY_PROPERTIES_NAME);
                        propertyFileToLoadIntoIvy = BACKUP_IVY_PROPERTIES_NAME;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to access the workspace ivy properties file '" + propertyFile + "'", e);
                        LOGGER.log(Level.WARNING, "Removing ModuleDescriptor");
                        return null;
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.WARNING, "Interrupted while accessing the workspace ivy properties file '" + propertyFile + "'", e);
                        File ivyP = new File(destDir, BACKUP_IVY_PROPERTIES_NAME);
                        if (!ivyP.canRead()) break block13;
                        LOGGER.log(Level.WARNING, "Will try to use use existing ivy properties backup");
                        propertyFileToLoadIntoIvy = BACKUP_IVY_PROPERTIES_NAME;
                    }
                }
            }
            if ((ivy = this.getIvy(destDir, propertyFileToLoadIntoIvy)) == null) {
                return null;
            }
            this.versionMatcher = ivy.getSettings().getVersionMatcher();
            String ivyDesc = this.getIvyFile();
            ivyF = null;
            if (ivyDesc != null && !ivyDesc.trim().isEmpty()) {
                ivyF = new File(destDir, BACKUP_IVY_FILE_NAME);
                try {
                    this.copyFileFromWorkspaceIfNecessary(b.getWorkspace(), ivyDesc, destDir, BACKUP_IVY_FILE_NAME);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to access the workspace ivy file '" + ivyDesc + "'", e);
                    if (ivyF.canRead()) {
                        LOGGER.log(Level.WARNING, "Will try to use use existing ivy file backup");
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Interrupted while accessing the workspace ivy file '" + ivyDesc + "'", e);
                    if (!ivyF.canRead()) break block14;
                    LOGGER.log(Level.WARNING, "Will try to use use existing ivy file backup");
                }
            }
        }
        if ((fivyF = ivyF) == null || !fivyF.canRead()) {
            LOGGER.log(Level.WARNING, "Cannot read ivy file backup...removing ModuleDescriptor");
            return null;
        }
        if (this.moduleDescriptor == null || fivyF.lastModified() > this.lastmodified) {
            this.lastmodified = fivyF.lastModified();
            return (ModuleDescriptor)ivy.execute(new Ivy.IvyCallback(){
                final /* synthetic */ IvyBuildTrigger this$0;
                {
                    this.this$0 = this$0;
                }

                public Object doInIvyContext(Ivy ivy, IvyContext context) {
                    try {
                        return ModuleDescriptorParserRegistry.getInstance().parseDescriptor((ParserSettings)ivy.getSettings(), fivyF.toURI().toURL(), ivy.getSettings().doValidate());
                    }
                    catch (MalformedURLException e) {
                        LOGGER.log(Level.WARNING, "The URL is malformed : " + String.valueOf(fivyF), e);
                        return null;
                    }
                    catch (ParseException e) {
                        LOGGER.log(Level.WARNING, "Parsing error while reading the ivy file " + String.valueOf(fivyF), e);
                        return null;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "I/O error while reading the ivy file " + String.valueOf(fivyF), e);
                        return null;
                    }
                }
            });
        }
        return null;
    }

    private void setModuleDescriptor(ModuleDescriptor d) {
        ModuleDescriptor old = this.moduleDescriptor;
        this.moduleDescriptor = d;
        if (old == this.moduleDescriptor) {
            return;
        }
        if (old == null || !old.equals((Object)this.moduleDescriptor)) {
            DESCRIPTOR.invalidateProjectMap();
            Jenkins.get().rebuildDependencyGraph();
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.setModuleDescriptor(this.recomputeModuleDescriptor(build));
        return true;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        DependencyDescriptor[] deps;
        ModuleDescriptor md = this.getModuleDescriptor(owner);
        if (md == null) {
            return;
        }
        for (DependencyDescriptor depDesc : deps = md.getDependencies()) {
            ModuleId id = depDesc.getDependencyId();
            ModuleRevisionId rid = depDesc.getDependencyRevisionId();
            List<AbstractProject> possibleDeps = DESCRIPTOR.getProjectsFor(id);
            boolean found = false;
            for (AbstractProject p : possibleDeps) {
                if (p.isDisabled()) {
                    p = null;
                }
                if (!(p instanceof Project) || !this.captures(rid, (Project)p)) continue;
                found = true;
                graph.addDependency((DependencyGraph.Dependency)new IvyThresholdDependency(p, owner, this.triggerWhenUnstable ? Result.UNSTABLE : Result.SUCCESS, this.useUpstreamParameters));
            }
            if (possibleDeps.isEmpty() || found) continue;
            LOGGER.warning("[" + owner.getName() + "] no matching versions for " + rid.toString());
        }
    }

    private boolean captures(ModuleRevisionId depRevId, Project candidate) {
        boolean captures;
        IvyBuildTrigger t = (IvyBuildTrigger)candidate.getPublisher((Descriptor)DESCRIPTOR);
        boolean bl = captures = t != null;
        if (captures && DESCRIPTOR.isExtendedVersionMatching()) {
            ModuleDescriptor cmd = t.getModuleDescriptor((AbstractProject)candidate);
            ModuleRevisionId cmrid = cmd.getModuleRevisionId();
            VersionMatcher matcher = this.versionMatcher;
            boolean bl2 = captures = matcher != null && matcher.isDynamic(depRevId);
            if (captures) {
                String dbranch = depRevId.getBranch();
                String cbranch = cmrid.getBranch();
                if (dbranch != null) {
                    captures = dbranch.equals(cbranch);
                } else {
                    boolean bl3 = captures = cbranch == null;
                }
                if (captures && (captures = matcher.accept(depRevId, cmrid)) && matcher.needModuleDescriptor(depRevId, cmrid)) {
                    captures = matcher.accept(depRevId, cmd);
                }
            }
        }
        return captures;
    }

    static {
        Message.setDefaultLogger((MessageLogger)new IvyMessageImpl());
        DESCRIPTOR = new DescriptorImpl();
    }

    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher>
    implements PersistentDescriptor {
        private volatile IvyConfiguration[] configurations = new IvyConfiguration[0];
        private volatile transient Map<ModuleId, List<AbstractProject>> projectMap = null;
        private volatile boolean extendedVersionMatching = false;

        private List<AbstractProject> getProjectsFor(ModuleId searchId) {
            List<Object> result;
            if (this.projectMap == null) {
                this.calculateProjectMap();
            }
            if ((result = this.projectMap.get(searchId)) == null) {
                result = Collections.emptyList();
            }
            return result;
        }

        private void invalidateProjectMap() {
            this.projectMap = null;
        }

        private void calculateProjectMap() {
            List projects = Jenkins.get().getAllItems(Project.class);
            HashMap<ModuleId, List<AbstractProject>> projectMap = new HashMap<ModuleId, List<AbstractProject>>();
            for (Project p : projects) {
                ModuleDescriptor m;
                IvyBuildTrigger t;
                if (p.isDisabled() || (t = (IvyBuildTrigger)p.getPublisher((Descriptor)DESCRIPTOR)) == null) continue;
                try {
                    m = t.getModuleDescriptor((AbstractProject)p);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Calculating the ModuleDescriptor failed for project " + p.getFullDisplayName(), e);
                    m = null;
                }
                if (m == null) continue;
                ModuleId id = m.getModuleRevisionId().getModuleId();
                ArrayList<Project> list = (ArrayList<Project>)projectMap.get(id);
                if (list == null) {
                    list = new ArrayList<Project>();
                }
                list.add(p);
                projectMap.put(id, list);
            }
            this.projectMap = projectMap;
        }

        public IvyConfiguration[] getConfigurations() {
            return this.configurations;
        }

        @DataBoundSetter
        public void setConfigurations(IvyConfiguration[] configurations) {
            this.configurations = configurations;
            this.save();
        }

        public boolean isExtendedVersionMatching() {
            return this.extendedVersionMatching;
        }

        @DataBoundSetter
        public void setExtendedVersionMatching(boolean extendedVersionMatching) {
            this.extendedVersionMatching = extendedVersionMatching;
            this.save();
        }

        public String getDisplayName() {
            return Messages.IvyBuildTrigger_DisplayName();
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) {
            try (BulkChange bc = new BulkChange((Saveable)this);){
                this.configurations = new IvyConfiguration[0];
                req.bindJSON((Object)this, json);
                bc.commit();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to save " + String.valueOf(this.getConfigFile()), e);
            }
            this.invalidateProjectMap();
            Jenkins.get().rebuildDependencyGraphAsync();
            return true;
        }

        public void doHandleExternalTrigger(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
            String org = Util.fixEmptyAndTrim((String)req.getParameter("org"));
            String name = Util.fixEmptyAndTrim((String)req.getParameter("name"));
            String branch = Util.fixEmptyAndTrim((String)req.getParameter("branch"));
            String rev = Util.fixEmptyAndTrim((String)req.getParameter("rev"));
            Jenkins.get().getACL().checkPermission(Item.BUILD);
            if (org == null || name == null) {
                throw new IllegalArgumentException("doHandleExternalTrigger requires the org and name parameters");
            }
            if (this.extendedVersionMatching && branch == null && rev == null) {
                throw new IllegalArgumentException("doHandleExternalTrigger requires rev or branch when using extended revision matching");
            }
            ModuleId id = ModuleId.newInstance((String)org, (String)name);
            String ivylabel = ModuleRevisionId.newInstance((String)org, (String)name, (String)branch, (String)Util.fixNull((String)rev)).toString();
            List downstream = Collections.emptyList();
            List<AbstractProject> candidates = this.getProjectsFor(id);
            for (AbstractProject candidate : candidates) {
                Project p;
                IvyBuildTrigger t;
                if (candidate.isDisabled() || !(candidate instanceof Project) || (t = (IvyBuildTrigger)(p = (Project)candidate).getPublisher((Descriptor)DESCRIPTOR)) == null) continue;
                if (this.extendedVersionMatching) {
                    ModuleDescriptor md = t.getModuleDescriptor((AbstractProject)p);
                    ModuleRevisionId mdrid = md.getModuleRevisionId();
                    String mdbranch = mdrid.getBranch();
                    if (branch != null && !branch.equals(mdbranch) || branch == null && mdbranch != null || rev != null && !rev.equals(mdrid.getRevision())) continue;
                }
                downstream = Jenkins.get().getDependencyGraph().getDownstream((AbstractProject)p);
                break;
            }
            for (AbstractProject down : downstream) {
                if (down.isDisabled()) continue;
                down.scheduleBuild((Cause)new UserCause(ivylabel));
            }
        }

        public FormValidation doCheckIvyConf(@QueryParameter String value) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (Util.fixEmpty((String)value) == null) {
                return FormValidation.error((String)Messages.IvyBuildTrigger_CheckIvyConf_PathRequiredError());
            }
            File f = new File(value);
            if (!f.isFile()) {
                return FormValidation.error((String)Messages.IvyBuildTrigger_CheckIvyConf_PathNotFileError(f));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIvyFile(@QueryParameter String value) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (Util.fixEmpty((String)value) == null) {
                return FormValidation.error((String)Messages.IvyBuildTrigger_CheckIvyFile_PathRequiredError());
            }
            if (new File(value).isAbsolute()) {
                return FormValidation.error((String)Messages.IvyBuildTrigger_CheckIvyFile_PathAbsoluteError());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return Project.class.isAssignableFrom(jobType);
        }
    }

    public static class IvyConfiguration
    extends AbstractDescribableImpl<IvyConfiguration> {
        private final String name;
        private final String ivyConfPath;

        @DataBoundConstructor
        public IvyConfiguration(String name, String ivyConfPath) {
            this.name = name;
            this.ivyConfPath = ivyConfPath;
        }

        public String getIvyConfPath() {
            return this.ivyConfPath;
        }

        public String getName() {
            return this.name;
        }

        public boolean getExists() {
            return new File(this.ivyConfPath).exists();
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<IvyConfiguration> {
        }
    }

    public static class UserCause
    extends Cause.UserIdCause {
        private final String ivylabel;

        public UserCause(String ivylabel) {
            this.ivylabel = ivylabel;
        }

        public String getIvylabel() {
            return this.ivylabel;
        }

        public String getShortDescription() {
            return Messages.IvyBuildTrigger_UserCause_ShortDescription(this.getIvylabel(), this.getUserName());
        }
    }
}

