/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.inlinepipeline;

import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import org.jenkinsci.plugins.inlinepipeline.InlineFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.multibranch.AbstractWorkflowBranchProjectFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class InlineDefinitionBranchProjectFactory
extends AbstractWorkflowBranchProjectFactory {
    private String script;
    private boolean sandbox;
    private String markerFile;

    @DataBoundConstructor
    public InlineDefinitionBranchProjectFactory() {
    }

    @DataBoundSetter
    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    @DataBoundSetter
    public void setSandbox(boolean sandbox) {
        this.sandbox = sandbox;
    }

    public boolean getSandbox() {
        return this.sandbox;
    }

    public String getMarkerFile() {
        return this.markerFile;
    }

    @DataBoundSetter
    public void setMarkerFile(String markerFile) {
        this.markerFile = markerFile;
    }

    protected FlowDefinition createDefinition() {
        return new InlineFlowDefinition(this.script, this.sandbox);
    }

    public SCMSourceCriteria getSCMSourceCriteria(SCMSource source) {
        return new SCMSourceCriteria(){

            public boolean isHead(SCMSourceCriteria.Probe probe, TaskListener listener) throws IOException {
                return probe.exists(InlineDefinitionBranchProjectFactory.this.markerFile);
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractWorkflowBranchProjectFactory.AbstractWorkflowBranchProjectFactoryDescriptor {
        public String getDisplayName() {
            return "Common pipeline definition for markerfile";
        }
    }
}

