/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.impliedlabels;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Descriptor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.impliedlabels.Config;
import org.jenkinsci.plugins.impliedlabels.Implication;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
@Symbol(value={"impliedLabels"})
public class ImpliedLabelsPlugin
extends GlobalConfiguration {
    public static ImpliedLabelsPlugin get() {
        return (ImpliedLabelsPlugin)((Object)Jenkins.get().getExtensionList(ImpliedLabelsPlugin.class).get(0));
    }

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"})
    public ImpliedLabelsPlugin() {
        this.load();
    }

    public Config getConfig() {
        return (Config)((Object)Jenkins.get().getExtensionList(Config.class).get(0));
    }

    protected XmlFile getConfigFile() {
        return this.getConfig().getConfigFile();
    }

    public void setImplications(List<Implication.ImplicationWrapper> implications) {
        try {
            this.getConfig().implications(implications.stream().map(p -> new Implication(p.getExpression(), p.getAtoms())).collect(Collectors.toList()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<Implication.ImplicationWrapper> getImplications() {
        return this.getConfig().implications().stream().map(i -> new Implication.ImplicationWrapper(i.expressionString(), i.atomsString())).collect(Collectors.toList());
    }

    public boolean configure(StaplerRequest2 req, JSONObject jsonObject) throws Descriptor.FormException {
        if (jsonObject.containsKey((Object)"impl")) {
            return false;
        }
        this.setImplications(Collections.emptyList());
        req.bindJSON((Object)this, jsonObject);
        this.save();
        return false;
    }
}

