/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.impliedlabels;

import antlr.ANTLRException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Label;
import hudson.model.LabelFinder;
import hudson.model.ManagementLink;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import hudson.util.CyclicGraphDetector;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.jcip.annotations.GuardedBy;
import org.jenkinsci.plugins.impliedlabels.Implication;
import org.jenkinsci.plugins.impliedlabels.Implier;
import org.jenkinsci.plugins.impliedlabels.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

@Restricted(value={NoExternalUse.class})
@Extension
public class Config
extends ManagementLink {
    @NonNull
    private static final Logger CACHE_LOGGER = Logger.getLogger("ConfigCaching");
    @GuardedBy(value="configLock")
    @NonNull
    private List<Implication> implications = Collections.emptyList();
    @GuardedBy(value="configLock")
    @NonNull
    private final transient Map<Collection<LabelAtom>, Collection<LabelAtom>> cache = new HashMap<Collection<LabelAtom>, Collection<LabelAtom>>();
    private final transient Object configLock = new Object();

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"})
    public Config() {
        try {
            this.load();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.CONFIGURATION;
    }

    public String getDisplayName() {
        return Messages.displayName();
    }

    public String getDescription() {
        return Messages.infer_redundant_labels();
    }

    public String getIconFileName() {
        return "symbol-pricetags-outline plugin-ionicons-api";
    }

    public String getUrlName() {
        return "label-implications";
    }

    @POST
    public void doConfigSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.implications(req.bindJSONToList(Implication.class, req.getSubmittedForm().get("impl")));
        rsp.sendRedirect("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void implications(@NonNull Collection<Implication> implications) throws IOException {
        List<Implication> im;
        try {
            im = Collections.unmodifiableList(Implication.sort(implications));
        }
        catch (CyclicGraphDetector.CycleDetectedException ex) {
            throw new IOException("Implication cycle detected", ex);
        }
        Object object = this.configLock;
        synchronized (object) {
            this.implications = im;
            CACHE_LOGGER.fine("Clearing cache when implications changed");
            this.cache.clear();
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<Implication> implications() {
        Object object = this.configLock;
        synchronized (object) {
            return this.implications;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Collection<LabelAtom> evaluate(@NonNull Node node) {
        Collection<LabelAtom> labels;
        Set<LabelAtom> initial = this.initialLabels(node);
        Object object = this.configLock;
        synchronized (object) {
            labels = this.cache.get(initial);
        }
        if (labels == null) {
            labels = new HashSet<LabelAtom>(initial);
            for (Implication i : this.implications()) {
                labels.addAll(i.infer(labels));
            }
            object = this.configLock;
            synchronized (object) {
                CACHE_LOGGER.fine("Caching " + String.valueOf(initial) + " -> " + String.valueOf(labels));
                this.cache.put(initial, labels);
            }
        }
        return labels;
    }

    @NonNull
    private Set<LabelAtom> initialLabels(@NonNull Node node) {
        HashSet<LabelAtom> result = new HashSet<LabelAtom>(Label.parse((String)node.getLabelString()));
        result.add(node.getSelfLabel());
        for (LabelFinder labeler : LabelFinder.all()) {
            if (labeler instanceof Implier) continue;
            for (Label label : labeler.findLabels(node)) {
                if (!(label instanceof LabelAtom)) continue;
                LabelAtom atom = (LabelAtom)label;
                result.add(atom);
            }
        }
        return result;
    }

    @NonNull
    public Collection<LabelAtom> detectRedundantLabels(@NonNull Node node) {
        Set<LabelAtom> initial = this.initialLabels(node);
        HashSet<LabelAtom> inferred = new HashSet<LabelAtom>();
        HashSet<LabelAtom> accumulated = new HashSet<LabelAtom>(initial);
        for (Implication i : this.implications()) {
            Collection<LabelAtom> ii = i.infer(accumulated);
            inferred.addAll(ii);
            accumulated.addAll(ii);
        }
        inferred.retainAll(initial);
        return inferred;
    }

    XmlFile getConfigFile() {
        File file = new File(Jenkins.get().root, ((Object)((Object)this)).getClass().getCanonicalName() + ".xml");
        return new XmlFile(Jenkins.XSTREAM, file);
    }

    void save() throws IOException {
        this.getConfigFile().write((Object)this);
    }

    void load() throws IOException {
        XmlFile file = this.getConfigFile();
        if (file.exists()) {
            file.unmarshal((Object)this);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public FormValidation doCheckExpression(@QueryParameter String expression) {
        if (Util.fixEmpty((String)expression) == null) {
            return FormValidation.ok();
        }
        try {
            Label.parseExpression((String)expression);
        }
        catch (ANTLRException ex) {
            return FormValidation.error((Throwable)ex, (String)Messages.invalid_label_expression());
        }
        return FormValidation.ok();
    }

    @Restricted(value={NoExternalUse.class})
    public FormValidation doInferLabels(@QueryParameter String labelString) {
        if (Util.fixEmpty((String)labelString) == null) {
            return FormValidation.ok();
        }
        Set labels = Label.parse((String)labelString);
        for (Implication i : this.implications()) {
            labels.addAll(i.infer(labels));
        }
        labels.removeAll(Label.parse((String)labelString));
        if (labels.isEmpty()) {
            return FormValidation.ok((String)Messages.no_labels_inferred());
        }
        return FormValidation.ok((String)Messages.inferred_labels(Util.join((Collection)labels, (String)" ")));
    }

    @Restricted(value={NoExternalUse.class})
    public AutoCompletionCandidates doAutoCompleteLabels(@QueryParameter String value) {
        AutoCompletionCandidates candidates = new AutoCompletionCandidates();
        for (LabelAtom atom : Jenkins.get().getLabelAtoms()) {
            if (!atom.getName().startsWith(value)) continue;
            candidates.add(atom.getName());
        }
        for (Implication i : this.implications()) {
            for (LabelAtom atom : i.atoms()) {
                if (!atom.getName().startsWith(value)) continue;
                candidates.add(atom.getName());
            }
        }
        return candidates;
    }
}

