// CHECKSTYLE:OFF

package org.jenkinsci.plugins.impliedlabels;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code infer_redundant_labels}: {@code Infer redundant labels
     * automatically based on user declaration}.
     * 
     * @return
     *     {@code Infer redundant labels automatically based on user declaration}
     */
    public static String infer_redundant_labels() {
        return holder.format("infer_redundant_labels");
    }

    /**
     * Key {@code infer_redundant_labels}: {@code Infer redundant labels
     * automatically based on user declaration}.
     * 
     * @return
     *     {@code Infer redundant labels automatically based on user declaration}
     */
    public static Localizable _infer_redundant_labels() {
        return new Localizable(holder, "infer_redundant_labels");
    }

    /**
     * Key {@code displayName}: {@code Label implications}.
     * 
     * @return
     *     {@code Label implications}
     */
    public static String displayName() {
        return holder.format("displayName");
    }

    /**
     * Key {@code displayName}: {@code Label implications}.
     * 
     * @return
     *     {@code Label implications}
     */
    public static Localizable _displayName() {
        return new Localizable(holder, "displayName");
    }

    /**
     * Key {@code invalid_label_expression}: {@code Invalid label
     * expression}.
     * 
     * @return
     *     {@code Invalid label expression}
     */
    public static String invalid_label_expression() {
        return holder.format("invalid_label_expression");
    }

    /**
     * Key {@code invalid_label_expression}: {@code Invalid label
     * expression}.
     * 
     * @return
     *     {@code Invalid label expression}
     */
    public static Localizable _invalid_label_expression() {
        return new Localizable(holder, "invalid_label_expression");
    }

    /**
     * Key {@code inferred_labels}: {@code Inferred labels: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Inferred labels: {0}}
     */
    public static String inferred_labels(Object arg0) {
        return holder.format("inferred_labels", arg0);
    }

    /**
     * Key {@code inferred_labels}: {@code Inferred labels: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Inferred labels: {0}}
     */
    public static Localizable _inferred_labels(Object arg0) {
        return new Localizable(holder, "inferred_labels", arg0);
    }

    /**
     * Key {@code no_labels_inferred}: {@code No labels inferred}.
     * 
     * @return
     *     {@code No labels inferred}
     */
    public static String no_labels_inferred() {
        return holder.format("no_labels_inferred");
    }

    /**
     * Key {@code no_labels_inferred}: {@code No labels inferred}.
     * 
     * @return
     *     {@code No labels inferred}
     */
    public static Localizable _no_labels_inferred() {
        return new Localizable(holder, "no_labels_inferred");
    }

}
