/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.hubot.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.thoughtslive.jenkins.plugins.hubot.api.ResponseData;
import retrofit2.Response;

public class Common {
    private static final Logger LOGGER = Logger.getLogger((String)Common.class.getName());

    public static String sanitizeURL(String url) {
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        return url;
    }

    public static void log(PrintStream logger, Object message) {
        if (logger != null) {
            logger.println(message);
        }
    }

    public static String getJobName(EnvVars envVars) {
        return (String)envVars.get((Object)"JOB_NAME");
    }

    public static String getBuildNumber(PrintStream logger, EnvVars envVars) {
        String answer = (String)envVars.get((Object)"BUILD_NUMBER");
        if (answer == null) {
            Common.log(logger, "No BUILD_NUMBER!");
            return "1";
        }
        return answer;
    }

    public static <T> ResponseData<T> parseResponse(Response<T> response) throws IOException {
        ResponseData<Object> resData = new ResponseData<Object>();
        resData.setSuccessful(response.isSuccessful());
        resData.setCode(response.code());
        resData.setMessage(response.message());
        if (!response.isSuccessful()) {
            String errorMessage = response.errorBody().string();
            resData.setError(errorMessage);
        } else {
            resData.setData(response.body());
        }
        return resData;
    }

    public static <T> ResponseData<T> buildErrorResponse(Exception e) {
        ResponseData resData = new ResponseData();
        String errorMessage = Common.getRootCause(e).getMessage();
        resData.setSuccessful(false);
        resData.setCode(-1);
        resData.setError(errorMessage);
        e.printStackTrace();
        return resData;
    }

    public static Throwable getRootCause(Throwable throwable) {
        if (throwable.getCause() != null) {
            return Common.getRootCause(throwable.getCause());
        }
        return throwable;
    }

    public static String prepareBuildUserName(List<Cause> causes, EnvVars envVars) {
        String buildUser = "anonymous";
        if (Util.fixEmpty((String)((String)envVars.get((Object)"CHANGE_AUTHOR"))) != null) {
            return (String)envVars.get((Object)"CHANGE_AUTHOR");
        }
        if (causes != null && causes.size() > 0) {
            if (causes.get(0) instanceof Cause.UserIdCause) {
                buildUser = ((Cause.UserIdCause)causes.get(0)).getUserName();
            } else if (causes.get(0) instanceof Cause.UpstreamCause) {
                List upstreamCauses = ((Cause.UpstreamCause)causes.get(0)).getUpstreamCauses();
                buildUser = Common.prepareBuildUserName(upstreamCauses, envVars);
            }
        }
        return buildUser;
    }

    public static String prepareBuildCause(List<Cause> causes) {
        String buildCause = null;
        if (causes != null && causes.size() > 0) {
            for (Cause cause : causes) {
                if (cause instanceof Cause.UserIdCause) {
                    buildCause = ((Cause.UserIdCause)causes.get(0)).getUserName();
                    continue;
                }
                if (cause instanceof Cause.UpstreamCause) {
                    List upstreamCauses = ((Cause.UpstreamCause)cause).getUpstreamCauses();
                    buildCause = Common.prepareBuildCause(upstreamCauses);
                    continue;
                }
                buildCause = cause.getClass().getSimpleName();
            }
        }
        return buildCause == null ? buildCause : buildCause.replace("Cause", "");
    }

    public static String prepareBuildUserId(List<Cause> causes, EnvVars envVars) {
        String buildUserId = null;
        if (causes != null && causes.size() > 0) {
            if (causes.get(0) instanceof Cause.UserIdCause) {
                buildUserId = ((Cause.UserIdCause)causes.get(0)).getUserId();
            } else if (causes.get(0) instanceof Cause.UpstreamCause) {
                List upstreamCauses = ((Cause.UpstreamCause)causes.get(0)).getUpstreamCauses();
                buildUserId = Common.prepareBuildUserId(upstreamCauses, envVars);
            }
        }
        return buildUserId;
    }

    @SuppressFBWarnings
    public static Map expandMacros(String tokens, Run<?, ?> run, FilePath ws, TaskListener listener) {
        HashMap<String, String> tokenMap = new HashMap<String, String>();
        if (Util.fixEmpty((String)tokens) != null) {
            for (String token : tokens.split(",")) {
                token = token.trim();
                String tokenExpand = null;
                try {
                    tokenExpand = TokenMacro.expand(run, (FilePath)ws, (TaskListener)listener, (String)("${" + token + "}"));
                }
                catch (Exception e) {
                    LOGGER.info((Object)("Hubot: ${" + token + "} not found."));
                }
                tokenMap.put(token, tokenExpand);
            }
        }
        return tokenMap;
    }

    public static <T> ResponseData<T> logResponse(ResponseData<T> response, PrintStream logger, boolean failOnError) throws AbortException {
        if (response.isSuccessful()) {
            Common.log(logger, "Hubot: Successful. Code: " + response.getCode());
        } else {
            Common.log(logger, "Hubot: Error Code: " + response.getCode());
            Common.log(logger, "Hubot: Error Message: " + response.getError());
            if (failOnError) {
                throw new AbortException(response.getError());
            }
        }
        return response;
    }

    public static enum STEP {
        SEND,
        APPROVE,
        BUILD,
        TEST;

    }
}

