/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.hubot.steps;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ParameterDefinition;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStep;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.thoughtslive.jenkins.plugins.hubot.api.Message;
import org.thoughtslive.jenkins.plugins.hubot.api.ResponseData;
import org.thoughtslive.jenkins.plugins.hubot.config.GlobalConfig;
import org.thoughtslive.jenkins.plugins.hubot.config.HubotFolderProperty;
import org.thoughtslive.jenkins.plugins.hubot.config.HubotSite;
import org.thoughtslive.jenkins.plugins.hubot.config.notifications.Type;
import org.thoughtslive.jenkins.plugins.hubot.steps.BasicHubotStep;
import org.thoughtslive.jenkins.plugins.hubot.util.Common;
import org.thoughtslive.jenkins.plugins.hubot.util.HubotStepExecution;

public class ApproveStep
extends BasicHubotStep {
    private static final long serialVersionUID = 2750983740619607854L;
    @DataBoundSetter
    private String id;
    @DataBoundSetter
    private String submitter;
    @DataBoundSetter
    private String ok;
    @DataBoundSetter
    private String submitterParameter;
    @DataBoundSetter
    private List<ParameterDefinition> parameters = Collections.emptyList();

    @DataBoundConstructor
    public ApproveStep(String message) {
        this.message = message;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ApproveStepExecution(this, context);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getSubmitter() {
        return this.submitter;
    }

    @Generated
    public String getOk() {
        return this.ok;
    }

    @Generated
    public String getSubmitterParameter() {
        return this.submitterParameter;
    }

    @Generated
    public List<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    public static class ApproveStepExecution
    extends HubotStepExecution<ResponseData<Void>> {
        private static final long serialVersionUID = 5535327378092782313L;
        private final ApproveStep step;
        private InputStepExecution inputExecution = null;

        protected ApproveStepExecution(ApproveStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        public boolean start() throws Exception {
            String status;
            ResponseData<Object> response = this.verifyCommon(this.step);
            String string = status = this.step.getStatus() == null ? Type.SUCCESS.name() : this.step.getStatus();
            if (response == null) {
                if (this.site != null) {
                    this.logger.println("Hubot: Sending " + status + " message to room: " + this.site.getRoom() + " of site: " + this.site.getName());
                } else {
                    this.logger.println("Hubot: ROOM - " + this.room + " - Approval Message - " + this.step.getMessage());
                }
                FilePath ws = (FilePath)this.getContext().get(FilePath.class);
                Map tokens = Common.expandMacros(this.step.getTokens(), this.run, ws, this.listener);
                String stepId = Util.fixEmpty((String)this.step.getId()) == null ? "Proceed" : this.step.getId().trim();
                ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                Message message = Message.builder().message(this.step.getMessage()).userName(this.buildUserName).userId(this.buildUserId).buildCause(this.buildCause).status(status).tokens(tokens).extraData(this.step.getExtraData()).envVars(this.envVars).stepName(Common.STEP.APPROVE.name()).ts(System.currentTimeMillis()).id(stepId).submitter(this.step.getSubmitter()).submitterParameter(this.step.getSubmitterParameter()).parameters(ow.writeValueAsString(this.step.getParameters())).ok(this.step.getOk()).build();
                response = this.hubotService.sendMessage(message);
            }
            Common.logResponse(response, this.logger, this.failOnError);
            try {
                InputStep input = new InputStep(this.step.getMessage());
                if (Util.fixEmpty((String)this.step.getId()) != null) {
                    input.setId(this.step.getId().trim());
                } else {
                    input.setId("Proceed");
                }
                input.setSubmitter(this.step.getSubmitter());
                input.setOk(this.step.getOk());
                input.setParameters(this.step.getParameters());
                input.setSubmitterParameter(this.step.getSubmitterParameter());
                InputStepExecution inputExecution = (InputStepExecution)input.start(this.getContext());
                return inputExecution.start();
            }
            catch (Exception e) {
                if (this.failOnError) {
                    throw new AbortException("Error while sending message: " + e.getMessage());
                }
                return false;
            }
        }

        public void stop(Throwable cause) throws Exception {
            if (this.inputExecution != null) {
                this.inputExecution.stop(cause);
            }
            this.getContext().onFailure(cause);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "hubotApprove";
        }

        public String getDisplayName() {
            return "Hubot: Send approval message";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class, EnvVars.class);
        }

        public ListBoxModel doFillSiteItems(@AncestorInPath Item project) {
            ArrayList<ListBoxModel.Option> hubotSites = new ArrayList<ListBoxModel.Option>();
            hubotSites.add(new ListBoxModel.Option("Optional - Please select, otherwise it will use default site from parent folder(s)/global.", ""));
            Object folderName = null;
            if (project != null) {
                ItemGroup parent = project.getParent();
                while (parent != null) {
                    if (parent instanceof AbstractFolder) {
                        HubotSite[] sites;
                        AbstractFolder folder = (AbstractFolder)parent;
                        folderName = folderName == null ? folder.getName() : folder.getName() + " \u00bb " + (String)folderName;
                        HubotFolderProperty jfp = (HubotFolderProperty)folder.getProperties().get(HubotFolderProperty.class);
                        if (jfp != null && (sites = jfp.getSites()) != null && sites.length > 0) {
                            for (HubotSite site : sites) {
                                hubotSites.add(new ListBoxModel.Option((String)folderName + " - " + site.getName(), site.getName()));
                            }
                        }
                    }
                    if (parent instanceof Item) {
                        parent = ((Item)parent).getParent();
                        continue;
                    }
                    parent = null;
                }
            }
            for (HubotSite site : new GlobalConfig().getSites()) {
                hubotSites.add(new ListBoxModel.Option("Global - " + site.getName(), site.getName()));
            }
            return new ListBoxModel(hubotSites);
        }
    }
}

