/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.hubot.listener;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.Map;
import org.thoughtslive.jenkins.plugins.hubot.api.Message;
import org.thoughtslive.jenkins.plugins.hubot.config.HubotSite;
import org.thoughtslive.jenkins.plugins.hubot.config.notifications.Config;
import org.thoughtslive.jenkins.plugins.hubot.config.notifications.Type;
import org.thoughtslive.jenkins.plugins.hubot.service.HubotService;
import org.thoughtslive.jenkins.plugins.hubot.util.Common;

@Extension
public class BuildListener
extends RunListener<Run<?, ?>> {
    @SuppressFBWarnings
    public void onCompleted(Run<?, ?> run, TaskListener listener) {
        HubotSite site = HubotSite.get(run.getParent(), listener);
        if (run.getPreviousBuild() != null) {
            Type type = Type.fromResults(run.getPreviousBuild().getResult(), run.getResult());
            if (site != null && site.getNotifications() != null) {
                for (Config config : site.getNotifications()) {
                    if (!config.isNotifyEnabled() || !config.getNotificationType().equals((Object)type)) continue;
                    if (Util.fixEmpty((String)config.getRoomNames()) != null) {
                        for (String roomName : config.getRoomNames().split(",")) {
                            this.sendMessage(run, listener, type, site, roomName.trim(), config);
                        }
                        continue;
                    }
                    this.sendMessage(run, listener, type, site, null, config);
                }
            }
        }
        super.onCompleted(run, listener);
    }

    public void onStarted(Run<?, ?> run, TaskListener listener) {
        HubotSite site = HubotSite.get(run.getParent(), listener);
        if (site != null && site.getNotifications() != null) {
            for (Config config : site.getNotifications()) {
                if (!config.isNotifyEnabled() || !config.getNotificationType().equals((Object)Type.STARTED)) continue;
                if (Util.fixEmpty((String)config.getRoomNames()) != null) {
                    for (String roomName : config.getRoomNames().split(",")) {
                        this.sendMessage(run, listener, Type.STARTED, site, roomName.trim(), config);
                    }
                    continue;
                }
                this.sendMessage(run, listener, Type.STARTED, site, null, config);
            }
        }
        super.onStarted(run, listener);
    }

    @SuppressFBWarnings
    private void sendMessage(Run<?, ?> run, TaskListener listener, Type type, HubotSite site, String roomName, Config config) {
        block4: {
            if (site != null) {
                try {
                    HubotSite cloneSite = site.clone();
                    if (Util.fixEmpty((String)roomName) != null) {
                        cloneSite.setRoom(roomName);
                        cloneSite.setRoomPrefix(null);
                    }
                    HubotService service = new HubotService(cloneSite);
                    String buildUserName = Common.prepareBuildUserName(run.getCauses(), run.getEnvironment(listener));
                    String buildUserId = Common.prepareBuildUserId(run.getCauses(), run.getEnvironment(listener));
                    Map tokens = Common.expandMacros(config.getTokens(), run, null, listener);
                    Message message = Message.builder().message(type.getStatus()).ts(System.currentTimeMillis()).envVars(run.getEnvironment(listener)).status(type.name()).tokens(tokens).buildCause(Common.prepareBuildCause(run.getCauses())).userId(buildUserId).userName(buildUserName).stepName(Common.STEP.BUILD.name()).build();
                    listener.getLogger().println("Hubot: Sending " + type.name() + " message to room: " + cloneSite.getRoom() + " of site: " + cloneSite.getName());
                    Common.logResponse(service.sendMessage(message), listener.getLogger(), site.isFailOnError());
                }
                catch (Exception e) {
                    listener.getLogger().println("Unable to send message to Hubot: " + Common.getRootCause(e).getMessage());
                    if (!site.isFailOnError()) break block4;
                    run.setResult(Result.FAILURE);
                }
            }
        }
    }
}

