/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.http_request.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import jenkins.plugins.http_request.HttpMode;
import jenkins.plugins.http_request.util.HttpMkcol;
import jenkins.plugins.http_request.util.HttpRequestNameValuePair;
import jenkins.plugins.http_request.util.RequestAction;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;

public class HttpClientUtil {
    public HttpUriRequestBase createRequestBase(RequestAction requestAction) throws IOException {
        HttpUriRequestBase httpRequestBase = this.doCreateRequestBase(requestAction);
        for (HttpRequestNameValuePair header : requestAction.getHeaders()) {
            httpRequestBase.addHeader(header.getName(), (Object)header.getValue());
        }
        return httpRequestBase;
    }

    private HttpUriRequestBase doCreateRequestBase(RequestAction requestAction) throws IOException {
        HttpGet http;
        if (requestAction.getMode() == HttpMode.HEAD) {
            return new HttpHead(this.getUrlWithParams(requestAction));
        }
        if (requestAction.getMode() == HttpMode.GET && (requestAction.getRequestBody() == null || requestAction.getRequestBody().isEmpty())) {
            return new HttpGet(this.getUrlWithParams(requestAction));
        }
        String uri = requestAction.getUrl().toString();
        if (requestAction.getMode() == HttpMode.GET) {
            http = new HttpGet(this.getUrlWithParams(requestAction));
        } else if (requestAction.getMode() == HttpMode.DELETE) {
            http = new HttpDelete(uri);
        } else if (requestAction.getMode() == HttpMode.PUT) {
            http = new HttpPut(uri);
        } else if (requestAction.getMode() == HttpMode.PATCH) {
            http = new HttpPatch(uri);
        } else {
            if (requestAction.getMode() == HttpMode.OPTIONS) {
                return new HttpOptions(this.getUrlWithParams(requestAction));
            }
            if (requestAction.getMode() == HttpMode.MKCOL) {
                return new HttpMkcol(uri);
            }
            http = new HttpPost(uri);
        }
        http.setEntity(this.makeEntity(requestAction));
        return http;
    }

    private HttpEntity makeEntity(RequestAction requestAction) {
        if (requestAction.getRequestBody() != null && !requestAction.getRequestBody().isEmpty()) {
            ContentType contentType = null;
            for (HttpRequestNameValuePair header : requestAction.getHeaders()) {
                if (!"Content-Type".equalsIgnoreCase(header.getName())) continue;
                contentType = ContentType.parse((CharSequence)header.getValue());
                break;
            }
            return new StringEntity(requestAction.getRequestBody(), contentType);
        }
        return HttpClientUtil.toUrlEncoded(requestAction.getParams());
    }

    private String getUrlWithParams(RequestAction requestAction) throws IOException {
        String url = requestAction.getUrl().toString();
        if (!requestAction.getParams().isEmpty()) {
            url = HttpClientUtil.appendParamsToUrl(url, requestAction.getParams());
        }
        return url;
    }

    private static UrlEncodedFormEntity toUrlEncoded(List<HttpRequestNameValuePair> params) {
        return new UrlEncodedFormEntity(params);
    }

    public static String appendParamsToUrl(String url, List<HttpRequestNameValuePair> params) throws IOException {
        url = (String)url + (((String)url).contains("?") ? "&" : "?");
        url = (String)url + HttpClientUtil.paramsToString(params);
        return url;
    }

    public static String paramsToString(List<HttpRequestNameValuePair> params) throws IOException {
        try (UrlEncodedFormEntity entity = HttpClientUtil.toUrlEncoded(params);){
            String string;
            block12: {
                InputStream is = entity.getContent();
                try {
                    string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    if (is == null) break block12;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return string;
        }
    }

    public HttpResponse execute(HttpClient client, HttpClientContext context, HttpUriRequestBase method, PrintStream logger) throws IOException {
        try {
            logger.println("Sending request to url: " + String.valueOf(method.getUri()));
            ClassicHttpResponse httpResponse = client.executeOpen(URIUtils.extractHost((URI)method.getUri()), (ClassicHttpRequest)method, (HttpContext)context);
            logger.println("Response Code: " + httpResponse.getCode());
            return httpResponse;
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

