/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.http_request;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jenkins.plugins.http_request.HttpMode;
import jenkins.plugins.http_request.HttpRequest;
import jenkins.plugins.http_request.HttpRequestExecution;
import jenkins.plugins.http_request.MimeType;
import jenkins.plugins.http_request.ResponseContentSupplier;
import jenkins.plugins.http_request.ResponseHandle;
import jenkins.plugins.http_request.util.HttpRequestFormDataPart;
import jenkins.plugins.http_request.util.HttpRequestNameValuePair;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public final class HttpRequestStep
extends Step {
    @NonNull
    private final String url;
    private boolean ignoreSslErrors = false;
    private HttpMode httpMode = DescriptorImpl.httpMode;
    private String httpProxy = "";
    private String proxyAuthentication = "";
    private String validResponseCodes = "100:399";
    private String validResponseContent = "";
    private MimeType acceptType = DescriptorImpl.acceptType;
    private MimeType contentType = DescriptorImpl.contentType;
    private Integer timeout = 0;
    private Boolean consoleLogResponseBody = DescriptorImpl.consoleLogResponseBody;
    private Boolean quiet = DescriptorImpl.quiet;
    private String authentication = "";
    private String requestBody = "";
    private String uploadFile = "";
    private String multipartName = "";
    private boolean wrapAsMultipart = true;
    private Boolean useSystemProperties = DescriptorImpl.useSystemProperties;
    private boolean useNtlm = false;
    private List<HttpRequestNameValuePair> customHeaders = DescriptorImpl.customHeaders;
    private List<HttpRequestFormDataPart> formData = DescriptorImpl.formData;
    private String outputFile = "";
    private ResponseHandle responseHandle = DescriptorImpl.responseHandle;

    @DataBoundConstructor
    public HttpRequestStep(@NonNull String url) {
        this.url = url;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public boolean isIgnoreSslErrors() {
        return this.ignoreSslErrors;
    }

    @DataBoundSetter
    public void setIgnoreSslErrors(boolean ignoreSslErrors) {
        this.ignoreSslErrors = ignoreSslErrors;
    }

    @DataBoundSetter
    public void setHttpMode(HttpMode httpMode) {
        this.httpMode = httpMode;
    }

    public HttpMode getHttpMode() {
        return this.httpMode;
    }

    @DataBoundSetter
    public void setHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    @DataBoundSetter
    public void setValidResponseCodes(String validResponseCodes) {
        this.validResponseCodes = validResponseCodes;
    }

    public String getValidResponseCodes() {
        return this.validResponseCodes;
    }

    @DataBoundSetter
    public void setValidResponseContent(String validResponseContent) {
        this.validResponseContent = validResponseContent;
    }

    public String getValidResponseContent() {
        return this.validResponseContent;
    }

    @DataBoundSetter
    public void setAcceptType(MimeType acceptType) {
        this.acceptType = acceptType;
    }

    public MimeType getAcceptType() {
        return this.acceptType;
    }

    @DataBoundSetter
    public void setContentType(MimeType contentType) {
        this.contentType = contentType;
    }

    public MimeType getContentType() {
        return this.contentType;
    }

    @DataBoundSetter
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setConsoleLogResponseBody(Boolean consoleLogResponseBody) {
        this.consoleLogResponseBody = consoleLogResponseBody;
    }

    public Boolean getConsoleLogResponseBody() {
        return this.consoleLogResponseBody;
    }

    @DataBoundSetter
    public void setQuiet(Boolean quiet) {
        this.quiet = quiet;
    }

    public Boolean getQuiet() {
        return this.quiet;
    }

    @DataBoundSetter
    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    @DataBoundSetter
    public void setProxyAuthentication(String proxyAuthentication) {
        this.proxyAuthentication = proxyAuthentication;
    }

    public String getProxyAuthentication() {
        return this.proxyAuthentication;
    }

    @DataBoundSetter
    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    @DataBoundSetter
    public void setUseSystemProperties(Boolean useSystemProperties) {
        this.useSystemProperties = useSystemProperties;
    }

    public Boolean getUseSystemProperties() {
        return this.useSystemProperties;
    }

    @DataBoundSetter
    public void setCustomHeaders(List<HttpRequestNameValuePair> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public List<HttpRequestNameValuePair> getCustomHeaders() {
        return this.customHeaders;
    }

    public List<HttpRequestFormDataPart> getFormData() {
        return this.formData;
    }

    @DataBoundSetter
    public void setFormData(List<HttpRequestFormDataPart> formData) {
        this.formData = Collections.unmodifiableList(formData);
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    @DataBoundSetter
    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public ResponseHandle getResponseHandle() {
        return this.responseHandle;
    }

    @DataBoundSetter
    public void setResponseHandle(ResponseHandle responseHandle) {
        this.responseHandle = responseHandle;
    }

    public String getUploadFile() {
        return this.uploadFile;
    }

    @DataBoundSetter
    public void setUploadFile(String uploadFile) {
        this.uploadFile = uploadFile;
    }

    public String getMultipartName() {
        return this.multipartName;
    }

    @DataBoundSetter
    public void setMultipartName(String multipartName) {
        this.multipartName = multipartName;
    }

    public boolean isWrapAsMultipart() {
        return this.wrapAsMultipart;
    }

    @DataBoundSetter
    public void setWrapAsMultipart(boolean wrapAsMultipart) {
        this.wrapAsMultipart = wrapAsMultipart;
    }

    @DataBoundSetter
    public void setUseNtlm(boolean useNtlm) {
        this.useNtlm = useNtlm;
    }

    public boolean isUseNtlm() {
        return this.useNtlm;
    }

    public StepExecution start(StepContext context) {
        return new Execution(context, this);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    List<HttpRequestNameValuePair> resolveHeaders() {
        ArrayList<HttpRequestNameValuePair> headers = new ArrayList<HttpRequestNameValuePair>();
        if (this.contentType != null && this.contentType != MimeType.NOT_SET) {
            headers.add(new HttpRequestNameValuePair("Content-Type", this.contentType.getContentType().toString()));
        }
        if (this.acceptType != null && this.acceptType != MimeType.NOT_SET) {
            headers.add(new HttpRequestNameValuePair("Accept", this.acceptType.getValue()));
        }
        for (HttpRequestNameValuePair header : this.customHeaders) {
            String headerName = header.getName();
            String headerValue = header.getValue();
            boolean maskValue = headerName.equalsIgnoreCase("Authorization") || header.getMaskValue();
            headers.add(new HttpRequestNameValuePair(headerName, headerValue, maskValue));
        }
        return headers;
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public static final boolean ignoreSslErrors = false;
        public static final HttpMode httpMode = HttpRequest.DescriptorImpl.httpMode;
        public static final String httpProxy = "";
        public static final String proxyAuthentication = "";
        public static final String validResponseCodes = "100:399";
        public static final String validResponseContent = "";
        public static final MimeType acceptType = HttpRequest.DescriptorImpl.acceptType;
        public static final MimeType contentType = HttpRequest.DescriptorImpl.contentType;
        public static final int timeout = 0;
        public static final Boolean consoleLogResponseBody = HttpRequest.DescriptorImpl.consoleLogResponseBody;
        public static final Boolean quiet = HttpRequest.DescriptorImpl.quiet;
        public static final String authentication = "";
        public static final String requestBody = "";
        public static final String uploadFile = "";
        public static final String multipartName = "";
        public static final boolean wrapAsMultipart = true;
        public static final Boolean useSystemProperties = HttpRequest.DescriptorImpl.useSystemProperties;
        public static final boolean useNtlm = false;
        public static final List<HttpRequestNameValuePair> customHeaders = Collections.emptyList();
        public static final List<HttpRequestFormDataPart> formData = Collections.emptyList();
        public static final String outputFile = "";
        public static final ResponseHandle responseHandle = ResponseHandle.STRING;

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, Run.class, TaskListener.class);
            return Collections.unmodifiableSet(context);
        }

        public String getFunctionName() {
            return "httpRequest";
        }

        @NonNull
        public String getDisplayName() {
            return "Perform an HTTP Request and return a response object";
        }

        public ListBoxModel doFillHttpModeItems() {
            return HttpMode.getFillItems();
        }

        public ListBoxModel doFillAcceptTypeItems() {
            return MimeType.getContentTypeFillItems();
        }

        public ListBoxModel doFillContentTypeItems() {
            return MimeType.getContentTypeFillItems();
        }

        public ListBoxModel doFillResponseHandleItems() {
            ListBoxModel items = new ListBoxModel();
            for (ResponseHandle responseHandle : ResponseHandle.values()) {
                items.add(responseHandle.name());
            }
            return items;
        }

        public ListBoxModel doFillAuthenticationItems(@AncestorInPath Item project, @QueryParameter String url) {
            return HttpRequest.DescriptorImpl.fillAuthenticationItems(project, url);
        }

        public ListBoxModel doFillProxyAuthenticationItems(@AncestorInPath Item project, @QueryParameter String url) {
            return HttpRequest.DescriptorImpl.fillAuthenticationItems(project, url);
        }

        public FormValidation doCheckValidResponseCodes(@QueryParameter String value) {
            return HttpRequest.DescriptorImpl.checkValidResponseCodes(value);
        }
    }

    public static final class Execution
    extends SynchronousNonBlockingStepExecution<ResponseContentSupplier> {
        private final transient HttpRequestStep step;
        private static final long serialVersionUID = 1L;

        Execution(@NonNull StepContext context, HttpRequestStep step) {
            super(context);
            this.step = step;
        }

        protected ResponseContentSupplier run() throws Exception {
            HttpRequestExecution exec = HttpRequestExecution.from(this.step, this.step.getQuiet() != false ? TaskListener.NULL : Objects.requireNonNull((TaskListener)this.getContext().get(TaskListener.class)), this);
            Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
            if (launcher != null) {
                VirtualChannel channel = launcher.getChannel();
                if (channel == null) {
                    throw new IllegalStateException("Launcher doesn't support remoting but it is required");
                }
                return (ResponseContentSupplier)channel.call((Callable)exec);
            }
            return exec.call();
        }

        FilePath resolveOutputFile() {
            String outputFile = this.step.getOutputFile();
            if (outputFile == null || outputFile.trim().isEmpty()) {
                return null;
            }
            try {
                FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
                if (workspace == null) {
                    throw new IllegalStateException("Could not find workspace to save file outputFile: " + outputFile + ". You should use it inside a 'node' block");
                }
                return workspace.child(outputFile);
            }
            catch (IOException | InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        FilePath resolveUploadFile() {
            return this.resolveUploadFileInternal(this.step.getUploadFile());
        }

        public Item getProject() throws IOException, InterruptedException {
            return Objects.requireNonNull((Run)this.getContext().get(Run.class)).getParent();
        }

        private FilePath resolveUploadFileInternal(String path) {
            if (path == null || path.trim().isEmpty()) {
                return null;
            }
            try {
                FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
                if (workspace == null) {
                    throw new IllegalStateException("Could not find workspace to check existence of upload file: " + path + ". You should use it inside a 'node' block");
                }
                FilePath uploadFilePath = workspace.child(path);
                if (!uploadFilePath.exists()) {
                    throw new IllegalStateException("Could not find upload file: " + path);
                }
                return uploadFilePath;
            }
            catch (IOException | InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        List<HttpRequestFormDataPart> resolveFormDataParts() {
            List<HttpRequestFormDataPart> formData = this.step.getFormData();
            if (formData == null || formData.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<HttpRequestFormDataPart> resolved = new ArrayList<HttpRequestFormDataPart>(formData.size());
            for (HttpRequestFormDataPart part : formData) {
                HttpRequestFormDataPart newPart = new HttpRequestFormDataPart(part.getUploadFile(), part.getName(), part.getFileName(), part.getContentType(), part.getBody());
                newPart.setResolvedUploadFile(this.resolveUploadFileInternal(part.getUploadFile()));
                resolved.add(newPart);
            }
            return resolved;
        }
    }
}

