/*
 * Decompiled with CFR 0.152.
 */
package htmlpublisher.util;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class FileEntryQueue {
    private static final FileEntry POISON_PILL = new FileEntry(null, null);
    private static final Map<UUID, FileEntryQueue> queues = new ConcurrentHashMap<UUID, FileEntryQueue>();
    private final LinkedBlockingQueue<FileEntry> queue = new LinkedBlockingQueue();
    private final AtomicInteger overallCount = new AtomicInteger(0);
    private final AtomicLong overallSize = new AtomicLong(0L);

    public static FileEntryQueue getOrCreateQueue(UUID queueKey) {
        return queues.computeIfAbsent(queueKey, key -> new FileEntryQueue());
    }

    public static FileEntryQueue remove(UUID queueKey) {
        return queues.remove(queueKey);
    }

    public FileEntry add(File file, String relativePath) {
        FileEntry entry = new FileEntry(file, relativePath);
        this.queue.add(entry);
        this.overallCount.incrementAndGet();
        this.overallSize.addAndGet(file.length());
        return entry;
    }

    public FileEntry take() throws InterruptedException {
        FileEntry entry = this.queue.take();
        if (entry == POISON_PILL) {
            this.queue.add(POISON_PILL);
            throw new InterruptedException();
        }
        return entry;
    }

    public void shutdown() {
        this.queue.add(POISON_PILL);
    }

    public void shutdownNow() {
        this.queue.clear();
        this.shutdown();
    }

    public int getOverallCount() {
        return this.overallCount.get();
    }

    public long getOverallSize() {
        return this.overallSize.get();
    }

    public Statistic getStatistic() {
        return new Statistic(this.getOverallCount(), this.getOverallSize());
    }

    public static class FileEntry
    implements Serializable {
        private File file;
        private String relativePath;
        private static final long serialVersionUID = 1L;

        public FileEntry(File file, String relativePath) {
            this.file = file;
            this.relativePath = relativePath;
        }

        public File getFile() {
            return this.file;
        }

        public String getRelativePath() {
            return this.relativePath;
        }
    }

    public static class Statistic
    implements Serializable {
        private int overallCount;
        private long overallSize;
        private static final long serialVersionUID = 1L;

        public Statistic(int overallCount, long overallSize) {
            this.overallCount = overallCount;
            this.overallSize = overallSize;
        }

        public int getOverallCount() {
            return this.overallCount;
        }

        public long getOverallSize() {
            return this.overallSize;
        }
    }
}

