/*
 * Decompiled with CFR 0.152.
 */
package htmlpublisher.util;

import htmlpublisher.util.DirScanningQueueWriter;
import htmlpublisher.util.FileEntryQueue;
import htmlpublisher.util.QueueReadingDirScanner;
import htmlpublisher.util.QueueShutdownAndRemover;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.util.DirScanner;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MultithreadedFileCopyHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyRecursiveTo(FilePath archiveDir, DirScanner dirScanner, FilePath targetDir, String description, int numberOfWorkers, ExecutorService executorService, int workerTimeoutInSeconds, TaskListener listener) throws IOException, InterruptedException, TimeoutException {
        PrintStream logger = listener.getLogger();
        long startTime = System.currentTimeMillis();
        UUID queueKey = UUID.randomUUID();
        try {
            HashSet<Future<Integer>> workers = new HashSet<Future<Integer>>();
            for (int i = 0; i < numberOfWorkers; ++i) {
                workers.add(executorService.submit(() -> {
                    QueueReadingDirScanner queueReadingDirScanner = new QueueReadingDirScanner(queueKey);
                    return archiveDir.copyRecursiveTo((DirScanner)queueReadingDirScanner, targetDir, description);
                }));
            }
            FileEntryQueue.Statistic queueStatistic = (FileEntryQueue.Statistic)archiveDir.act((FilePath.FileCallable)new DirScanningQueueWriter(dirScanner, queueKey));
            int transferedFiles = 0;
            for (Future future : workers) {
                try {
                    transferedFiles += ((Integer)future.get(workerTimeoutInSeconds, TimeUnit.SECONDS)).intValue();
                }
                catch (ExecutionException e) {
                    throw new IOException(e);
                }
            }
            float overallSizeInMB = (float)queueStatistic.getOverallSize() / 1024.0f / 1024.0f;
            float f = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            logger.format("Copied %,d file(s) / %,.1f MB --> %,.1f MB/s", queueStatistic.getOverallCount(), Float.valueOf(overallSizeInMB), Float.valueOf(overallSizeInMB / f)).println();
            int n = transferedFiles;
            return n;
        }
        finally {
            archiveDir.act((FilePath.FileCallable)new QueueShutdownAndRemover(queueKey));
        }
    }
}

