/*
 * Decompiled with CFR 0.152.
 */
package htmlpublisher.util;

import htmlpublisher.util.FileEntryQueue;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class QueueReadingDirScanner
extends DirScanner {
    private UUID queueKey;
    private static final long serialVersionUID = 1L;

    public QueueReadingDirScanner(UUID queueKey) {
        this.queueKey = queueKey;
    }

    public void scan(File file, FileVisitor visitor) throws IOException {
        FileEntryQueue queue = FileEntryQueue.getOrCreateQueue(this.queueKey);
        try {
            while (true) {
                FileEntryQueue.FileEntry entry = queue.take();
                visitor.visit(entry.getFile(), entry.getRelativePath());
            }
        }
        catch (InterruptedException entry) {
        }
        catch (IOException e) {
            queue.shutdownNow();
            throw e;
        }
    }
}

