/*
 * Decompiled with CFR 0.152.
 */
package htmlpublisher;

import edu.umd.cs.findbugs.annotations.NonNull;
import htmlpublisher.HtmlPublisherTarget;
import htmlpublisher.util.MultithreadedFileCopyHelper;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.DirScanner;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import jenkins.util.Timer;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class HtmlPublisher
extends Recorder {
    static boolean FOLLOW_SYMLINKS = SystemProperties.getBoolean((String)(HtmlPublisher.class.getName() + ".FOLLOW_SYMLINKS"), (boolean)false);
    static int PUBLISH_WORKER_TIMEOUT = SystemProperties.getInteger((String)(HtmlPublisher.class.getName() + ".PUBLISH_WORKER_TIMEOUT"), (Integer)300);
    private final List<HtmlPublisherTarget> reportTargets;
    private static final String HEADER = "/htmlpublisher/HtmlPublisher/header.html";
    private static final String FOOTER = "/htmlpublisher/HtmlPublisher/footer.html";

    @DataBoundConstructor
    @Restricted(value={NoExternalUse.class})
    public HtmlPublisher(List<HtmlPublisherTarget> reportTargets) {
        this.reportTargets = reportTargets != null ? new ArrayList<HtmlPublisherTarget>(reportTargets) : new ArrayList();
    }

    public List<HtmlPublisherTarget> getReportTargets() {
        return this.reportTargets;
    }

    private static String writeFile(List<String> lines, File path) throws IOException, NoSuchAlgorithmException {
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        try (FileOutputStream fos = new FileOutputStream(path);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, Charset.defaultCharset());
             BufferedWriter bw = new BufferedWriter(osw);){
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i) + "\n";
                bw.write(line);
                sha1.update(line.getBytes(StandardCharsets.UTF_8));
            }
        }
        return Util.toHexString((byte[])sha1.digest());
    }

    public List<String> readFile(String filePath) throws IOException {
        return HtmlPublisher.readFile(filePath, ((Object)((Object)this)).getClass());
    }

    public static List<String> readFile(String filePath, Class<?> publisherClass) throws IOException {
        ArrayList<String> aList = new ArrayList<String>();
        try (InputStream is = publisherClass.getResourceAsStream(filePath);
             InputStreamReader r = new InputStreamReader(is, Charset.defaultCharset());
             BufferedReader br = new BufferedReader(r);){
            String line;
            while ((line = br.readLine()) != null) {
                aList.add(line);
            }
        }
        return aList;
    }

    protected static String resolveParametersInString(Run<?, ?> build, TaskListener listener, String input) {
        PrintStream logger = listener.getLogger();
        if (build instanceof AbstractBuild) {
            try {
                return build.getEnvironment(listener).expand(input);
            }
            catch (Exception e) {
                logger.println("Failed to resolve parameters in string \"" + input + "\" due to following error:\n" + e.getMessage());
            }
        } else {
            if (input.matches("\\$\\{.*\\}")) {
                logger.println("***************");
                logger.println("*** WARNING ***");
                logger.println("***************");
                logger.print("You appear to be relying on the HTML Publisher plugin to resolve variables in a Pipeline build. ");
                logger.print("This is not considered best practice and will be removed in a future release. ");
                logger.println("Please use a Groovy mechanism to evaluate the string.");
            }
            try {
                return build.getEnvironment(listener).expand(input);
            }
            catch (Exception e) {
                logger.println("Failed to resolve parameters in string \"" + input + "\" due to following error:\n" + e.getMessage());
            }
        }
        return input;
    }

    protected static String resolveParametersInString(EnvVars envVars, TaskListener listener, String input) {
        try {
            return envVars.expand(input);
        }
        catch (Exception e) {
            listener.getLogger().println("Failed to resolve parameters in string \"" + input + "\" due to following error:\n" + e.getMessage());
            return input;
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        return HtmlPublisher.publishReports(build, build.getWorkspace(), (TaskListener)listener, this.reportTargets, ((Object)((Object)this)).getClass());
    }

    public static boolean publishReports(Run<?, ?> build, FilePath workspace, TaskListener listener, List<HtmlPublisherTarget> reportTargets, Class<?> publisherClass) throws InterruptedException {
        List<String> footerLines;
        List<String> headerLines;
        PrintStream logger = listener.getLogger();
        logger.println("[htmlpublisher] Archiving HTML reports...");
        try {
            headerLines = HtmlPublisher.readFile(HEADER, publisherClass);
        }
        catch (IOException ex) {
            logger.print("Exception occurred reading file /htmlpublisher/HtmlPublisher/header.html, message:" + ex.getMessage());
            return false;
        }
        try {
            footerLines = HtmlPublisher.readFile(FOOTER, publisherClass);
        }
        catch (IOException ex) {
            logger.print("Exception occurred reading file /htmlpublisher/HtmlPublisher/footer.html, message:" + ex.getMessage());
            return false;
        }
        for (int i = 0; i < reportTargets.size(); ++i) {
            String[] splitPatterns;
            ArrayList<String> reportLines = new ArrayList<String>(headerLines);
            reportLines.add("<script type=\"text/javascript\" src=\"" + HtmlPublisher.getStaticResourcesUrl() + "/plugin/htmlpublisher/js/htmlpublisher.js\"></script>");
            HtmlPublisherTarget reportTarget = reportTargets.get(i);
            boolean keepAll = reportTarget.getKeepAll();
            boolean allowMissing = reportTarget.getAllowMissing();
            FilePath archiveDir = workspace.child(HtmlPublisher.resolveParametersInString(build, listener, reportTarget.getReportDir()));
            FilePath targetDir = reportTarget.getArchiveTarget(build);
            String levelString = keepAll ? "BUILD" : "PROJECT";
            logger.println("[htmlpublisher] Archiving at " + levelString + " level " + String.valueOf(archiveDir) + " to " + targetDir.getName());
            try {
                if (!archiveDir.exists()) {
                    if (!allowMissing) {
                        listener.error("Specified HTML directory '" + String.valueOf(archiveDir) + "' does not exist.");
                        build.setResult(Result.FAILURE);
                        return true;
                    }
                    logger.println("[htmlpublisher] Specified HTML directory '" + String.valueOf(archiveDir) + "' does not exist.");
                }
                if (!keepAll) {
                    targetDir.deleteRecursive();
                }
                int copied = 0;
                if (FOLLOW_SYMLINKS) {
                    copied = archiveDir.copyRecursiveTo(reportTarget.getIncludes(), targetDir);
                } else {
                    int numberOfWorkers = reportTarget.getNumberOfWorkers();
                    DirScanner dirScanner = HtmlPublisher.dirScannerGlob(reportTarget.getIncludes(), null, true, LinkOption.NOFOLLOW_LINKS);
                    if (numberOfWorkers <= 1) {
                        logger.println("[htmlpublisher] Copying recursive using current thread");
                        copied = archiveDir.copyRecursiveTo(dirScanner, targetDir, reportTarget.getIncludes());
                    } else {
                        logger.println("[htmlpublisher] Copying recursive using " + numberOfWorkers + " workers");
                        copied = MultithreadedFileCopyHelper.copyRecursiveTo(archiveDir, dirScanner, targetDir, reportTarget.getIncludes(), numberOfWorkers, Timer.get(), PUBLISH_WORKER_TIMEOUT, listener);
                    }
                }
                if (copied == 0) {
                    if (allowMissing) continue;
                    listener.error("Directory '" + String.valueOf(archiveDir) + "' exists but failed copying to '" + targetDir.getName() + "'.");
                    Result buildResult = build.getResult();
                    if (buildResult != null && buildResult.isBetterOrEqualTo(Result.UNSTABLE)) {
                        listener.error("This is especially strange since your build otherwise succeeded.");
                    }
                    build.setResult(Result.FAILURE);
                    return true;
                }
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    Util.displayIOException((IOException)((IOException)e), (TaskListener)listener);
                }
                e.printStackTrace(listener.fatalError("HTML Publisher failure"));
                build.setResult(Result.FAILURE);
                return true;
            }
            ArrayList<String> csvReports = new ArrayList<String>();
            File targetDirFile = new File(targetDir.getRemote());
            for (String pattern : splitPatterns = HtmlPublisher.resolveParametersInString(build, listener, reportTarget.getReportFiles()).split(",")) {
                FileSet fs = Util.createFileSet((File)targetDirFile, (String)pattern);
                csvReports.addAll(Arrays.asList(fs.getDirectoryScanner().getIncludedFiles()));
            }
            String[] titles = null;
            if (reportTarget.getReportTitles() != null && reportTarget.getReportTitles().trim().length() > 0) {
                titles = reportTarget.getReportTitles().trim().split("\\s*,\\s*");
                for (int j = 0; j < titles.length; ++j) {
                    titles[j] = HtmlPublisher.resolveParametersInString(build, listener, titles[j]);
                }
            }
            ArrayList<String> reports = new ArrayList<String>();
            for (int j = 0; j < csvReports.size(); ++j) {
                String report = (String)csvReports.get(j);
                report = report.trim();
                if ((report = report.replace("\\", "/")).isEmpty()) continue;
                reports.add(report);
                String tabNo = "tab" + (j + 1);
                int end = report.lastIndexOf(46);
                String reportFile = end > 0 ? report.substring(0, end) : report;
                String tabItem = "<li id=\"" + tabNo + "\" class=\"unselected\" value=\"" + Functions.htmlAttributeEscape((String)report) + "\">" + Functions.htmlAttributeEscape((String)HtmlPublisher.getTitle(reportFile, titles, j)) + "</li>";
                reportLines.add(tabItem);
            }
            String hudsonUrl = Jenkins.get().getRootUrl();
            Job job = build.getParent();
            reportLines.add("<span class='links-data-holder' data-back-to-name='" + job.getName() + "' data-root-url='" + hudsonUrl + "' data-job-url='" + job.getUrl() + "' data-zip-link='" + reportTarget.getSanitizedName() + "'/>");
            reportLines.addAll(footerLines);
            File outputFile = new File(targetDir.getRemote(), reportTarget.getWrapperName());
            try {
                if (!archiveDir.exists()) continue;
                String checksum = HtmlPublisher.writeFile(reportLines, outputFile);
                reportTarget.handleAction(build, checksum);
                continue;
            }
            catch (IOException e) {
                logger.println("Error: IOException occurred writing report to file " + outputFile.getName() + " to archiveDir:" + archiveDir.getName() + ", error:" + e.getMessage().replace(outputFile.getParent(), ""));
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                logger.println("Error: NoSuchAlgorithmException occurred writing report to file " + outputFile.getName() + " to archiveDir:" + archiveDir.getName() + ", error:" + e.getMessage().replace(outputFile.getParent(), ""));
            }
        }
        return true;
    }

    private static String getTitle(String report, String[] titles, int j) {
        if (titles != null && titles.length > j) {
            return titles[j];
        }
        return report;
    }

    @NonNull
    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        if (this.reportTargets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        for (HtmlPublisherTarget target : this.reportTargets) {
            actions.add(target.getProjectAction((AbstractItem)project));
            if (!project.getClass().getName().equals("hudson.matrix.MatrixProject")) continue;
            HtmlPublisher.adjustMatrixProject(project);
        }
        return actions;
    }

    private static String getStaticResourcesUrl() {
        String rootUrl = Jenkins.get().getRootUrl();
        if (rootUrl == null) {
            rootUrl = "";
        }
        return StringUtils.stripEnd((String)rootUrl, (String)"/") + Functions.getResourcePath();
    }

    private static void adjustMatrixProject(AbstractProject<?, ?> project) {
        MatrixProject mp = (MatrixProject)project;
        if (mp.getActiveConfigurations() != null) {
            for (MatrixConfiguration mc : mp.getActiveConfigurations()) {
                try {
                    mc.onLoad((ItemGroup)mc.getParent(), mc.getName());
                }
                catch (IOException iOException) {}
            }
        }
    }

    @SuppressRestrictedWarnings(value={NoExternalUse.class})
    public static DirScanner dirScannerGlob(String includes, String excludes, boolean useDefaultExcludes, OpenOption ... openOptions) throws Exception {
        return new DirScanner.Glob(includes, excludes, useDefaultExcludes, openOptions);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @NonNull
        public String getDisplayName() {
            return "Publish HTML reports";
        }

        public FormValidation doCheck(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            FilePath ws = project.getSomeWorkspace();
            return ws != null ? ws.validateRelativeDirectory(value) : FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

