/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import groovy.lang.GroovyObject;
import groovy.lang.Writable;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.groovy.Groovy;
import hudson.plugins.groovy.GroovyInstallation;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.ClassFilter;
import hudson.remoting.ObjectInputStreamEx;
import hudson.remoting.VirtualChannel;
import hudson.remoting.Which;
import hudson.slaves.WorkspaceList;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.ivy.util.extendable.ExtendableItem;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.GeneralNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class WithGroovyStep
extends Step {
    private String tool;
    private String jdk;
    private Object input;

    @DataBoundConstructor
    public WithGroovyStep() {
    }

    public String getTool() {
        return this.tool;
    }

    @DataBoundSetter
    public void setTool(String tool) {
        this.tool = Util.fixEmpty((String)tool);
    }

    public String getJdk() {
        return this.jdk;
    }

    @DataBoundSetter
    public void setJdk(String jdk) {
        this.jdk = Util.fixEmpty((String)jdk);
    }

    public Object getInput() {
        return this.input;
    }

    @DataBoundSetter
    public void setInput(Object input) {
        this.input = input;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context, this);
    }

    private static class Execution
    extends GeneralNonBlockingStepExecution {
        private static final long serialVersionUID = 1L;
        private final transient WithGroovyStep step;

        Execution(StepContext context, WithGroovyStep step) {
            super(context);
            this.step = step;
        }

        public boolean start() throws Exception {
            this.run(() -> {
                String home;
                FilePath base = WorkspaceList.tempDir((FilePath)((FilePath)this.getContext().get(FilePath.class)));
                base.mkdirs();
                FilePath tmp = base.createTempDir("jenkins-groovy-step", "");
                HashMap<String, String> env = new HashMap<String, String>();
                if (this.step.tool != null) {
                    GroovyInstallation installation = Groovy.DescriptorImpl.getGroovy(this.step.tool);
                    if (installation == null) {
                        throw new AbortException("no such Groovy installation " + this.step.tool);
                    }
                    installation = installation.forNode((Node)this.getContext().get(Node.class), (TaskListener)this.getContext().get(TaskListener.class));
                    installation = installation.forEnvironment((EnvVars)this.getContext().get(EnvVars.class));
                    home = installation.getHome();
                    env.put("PATH+GROOVY", tmp.child(home).child("bin").getRemote());
                    env.put("GROOVY_HOME", tmp.child(home).getRemote());
                } else {
                    FilePath bin = tmp.child("bin");
                    FilePath groovySh = bin.child("groovy");
                    groovySh.copyFrom(WithGroovyStep.class.getResource("groovy.sh"));
                    groovySh.chmod(493);
                    bin.child("groovy.bat").copyFrom(WithGroovyStep.class.getResource("groovy.bat"));
                    env.put("PATH+GROOVY", bin.getRemote());
                    env.put("CLASSPATH+GROOVYALL", FindGroovyAllJAR.runIn(tmp.getChannel(), (TaskListener)this.getContext().get(TaskListener.class)));
                }
                if (this.step.jdk != null) {
                    JDK jdk = null;
                    for (JDK _jdk : ((JDK.DescriptorImpl)Jenkins.get().getDescriptorByType(JDK.DescriptorImpl.class)).getInstallations()) {
                        if (!_jdk.getName().equals(this.step.jdk)) continue;
                        jdk = _jdk;
                        break;
                    }
                    if (jdk == null) {
                        throw new AbortException("no such JDK installation " + this.step.jdk);
                    }
                    jdk = jdk.forNode((Node)this.getContext().get(Node.class), (TaskListener)this.getContext().get(TaskListener.class));
                    jdk = jdk.forEnvironment((EnvVars)this.getContext().get(EnvVars.class));
                    home = jdk.getHome();
                    env.put("PATH+JDK", tmp.child(home).child("bin").getRemote());
                }
                if (this.step.input != null) {
                    try (OutputStream os = tmp.child("input.ser").write();
                         ObjectOutputStream oos = new ObjectOutputStream(os);){
                        oos.writeObject(this.step.input);
                    }
                    tmp.child("Pipeline.groovy").copyFrom(WithGroovyStep.class.getResource("Pipeline.groovy"));
                    env.put("CLASSPATH+GROOVY", tmp.getRemote());
                }
                this.getContext().newBodyInvoker().withContext((Object)EnvironmentExpander.constant(env)).withCallback((BodyExecutionCallback)new Callback(tmp)).start();
            });
            return false;
        }

        private static class FindGroovyAllJAR
        extends MasterToSlaveCallable<String, IOException> {
            private FindGroovyAllJAR() {
            }

            @CheckForNull
            private static Class<?> anIvyClass(@CheckForNull TaskListener listener) {
                try {
                    return ExtendableItem.class;
                }
                catch (NoClassDefFoundError x) {
                    if (listener != null) {
                        listener.getLogger().println("@Grab will not be available unless the plugin Pipeline: Shared Groovy Libraries is enabled");
                    }
                    return null;
                }
            }

            static String runIn(VirtualChannel channel, TaskListener listener) throws IOException, InterruptedException {
                Class<?> ivy = FindGroovyAllJAR.anIvyClass(listener);
                if (channel instanceof Channel) {
                    Class[] classArray;
                    Class<Writable> groovy = Writable.class;
                    if (ivy != null) {
                        Class[] classArray2 = new Class[2];
                        classArray2[0] = groovy;
                        classArray = classArray2;
                        classArray2[1] = ivy;
                    } else {
                        Class[] classArray3 = new Class[1];
                        classArray = classArray3;
                        classArray3[0] = groovy;
                    }
                    Class[] classesInJar = classArray;
                    ((Channel)channel).preloadJar(WithGroovyStep.class.getClassLoader(), classesInJar);
                }
                return (String)channel.call((Callable)new FindGroovyAllJAR());
            }

            public String call() throws IOException {
                Class<?> ivy = FindGroovyAllJAR.anIvyClass(null);
                return Which.jarFile(Writable.class).getAbsolutePath() + (String)(ivy != null ? File.pathSeparator + Which.jarFile(ivy).getAbsolutePath() : "");
            }
        }

        private class Callback
        extends BodyExecutionCallback {
            private static final long serialVersionUID = 1L;
            private final String tmp;

            Callback(FilePath tmp) {
                this.tmp = tmp.getRemote();
            }

            public void onSuccess(StepContext context, Object result) {
                Execution.this.run(() -> {
                    block13: {
                        try {
                            FilePath ser = ((FilePath)context.get(FilePath.class)).child(this.tmp).child("output.ser");
                            if (!ser.exists()) break block13;
                            try (InputStream is = ser.read();){
                                try (ObjectInputStreamEx ois = new ObjectInputStreamEx(is, GroovyObject.class.getClassLoader(), ClassFilter.DEFAULT);){
                                    context.onSuccess(ois.readObject());
                                }
                                return;
                            }
                        }
                        catch (Throwable x) {
                            context.onFailure(x);
                            return;
                        }
                    }
                    context.onSuccess(result);
                });
            }

            public void onFailure(StepContext context, Throwable t) {
                context.onFailure(t);
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "withGroovy";
        }

        public String getDisplayName() {
            return "Execute Groovy script";
        }

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(FilePath.class, Node.class, EnvVars.class, TaskListener.class);
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public ListBoxModel doFillToolItems() {
            ListBoxModel m = new ListBoxModel();
            m.add("(Default)", "");
            for (GroovyInstallation inst : ((GroovyInstallation.DescriptorImpl)Jenkins.get().getDescriptorByType(GroovyInstallation.DescriptorImpl.class)).getInstallations()) {
                m.add(inst.getName());
            }
            return m;
        }

        public ListBoxModel doFillJdkItems() {
            ListBoxModel m = new ListBoxModel();
            m.add("(Default)", "");
            for (JDK inst : ((JDK.DescriptorImpl)Jenkins.get().getDescriptorByType(JDK.DescriptorImpl.class)).getInstallations()) {
                m.add(inst.getName());
            }
            return m;
        }
    }
}

