/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import hudson.plugins.groovy.AbstractGroovy;
import hudson.plugins.groovy.FileScriptSource;
import hudson.plugins.groovy.ScriptSource;
import hudson.plugins.groovy.StringScriptSource;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class Groovy
extends AbstractGroovy {
    private ScriptSource scriptSource;
    private String groovyName;
    private String parameters;
    private String scriptParameters;
    private String properties;
    private String javaOpts;
    private String classPath;
    private BuilderType type;
    private String command;
    private String scriptFile;

    @DataBoundConstructor
    public Groovy(ScriptSource scriptSource, String groovyName, String parameters, String scriptParameters, String properties, String javaOpts, String classPath) {
        this.scriptSource = scriptSource;
        this.groovyName = groovyName;
        this.parameters = parameters;
        this.scriptParameters = scriptParameters;
        this.properties = properties;
        this.javaOpts = javaOpts;
        this.classPath = classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.scriptSource == null) {
            listener.fatalError("There is no script configured for this builder");
            return false;
        }
        FilePath ws = build.getWorkspace();
        FilePath script = null;
        try {
            script = this.scriptSource.getScriptFile(ws, build, listener);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to produce a script file"));
            return false;
        }
        try {
            int result;
            List<String> cmd = this.buildCommandLine(build, listener, script, launcher.isUnix());
            try {
                EnvVars envVars = build.getEnvironment((TaskListener)listener);
                hudson.plugins.groovy.GroovyInstallation installation = this.getGroovy();
                if (installation != null) {
                    Node node = Computer.currentComputer().getNode();
                    if (node != null) {
                        installation = installation.forNode(node, (TaskListener)listener);
                    }
                    envVars.put("GROOVY_HOME", installation.getHome());
                }
                for (Map.Entry entry : build.getBuildVariables().entrySet()) {
                    envVars.put((String)entry.getKey(), (String)entry.getValue());
                }
                String origJavaOpts = (String)build.getBuildVariables().get("JAVA_OPTS");
                StringBuilder stringBuilder = new StringBuilder(origJavaOpts != null ? origJavaOpts : "");
                if (this.javaOpts != null) {
                    stringBuilder.append(' ').append(this.javaOpts);
                }
                envVars.put("JAVA_OPTS", stringBuilder.toString());
                envVars.put("$PATH_SEPARATOR", ":::");
                result = launcher.launch().cmds(cmd.toArray(new String[0])).envs((Map)envVars).stdout((TaskListener)listener).pwd(ws).join();
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("command execution failed"));
                result = -1;
            }
            boolean bl = result == 0;
            return bl;
        }
        finally {
            try {
                if (this.scriptSource instanceof StringScriptSource && script != null) {
                    script.delete();
                }
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to delete script file " + String.valueOf(script)));
            }
        }
    }

    protected hudson.plugins.groovy.GroovyInstallation getGroovy() {
        return DescriptorImpl.getGroovy(this.groovyName);
    }

    protected List<String> buildCommandLine(AbstractBuild<?, ?> build, BuildListener listener, FilePath script, boolean isOnUnix) throws IOException, InterruptedException {
        ArrayList<String> list = new ArrayList<String>();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        VariableResolver.ByMap vr = new VariableResolver.ByMap((Map)env);
        String cmd = "groovy";
        hudson.plugins.groovy.GroovyInstallation installation = this.getGroovy();
        if (installation != null) {
            Node node = Computer.currentComputer().getNode();
            if (node != null) {
                installation = installation.forNode(node, (TaskListener)listener);
            }
            if (null == (cmd = (installation = installation.forEnvironment(env)).getExecutable(script.getChannel()))) {
                cmd = "groovy";
                listener.getLogger().println("[GROOVY WARNING] Groovy executable is NULL, please check your Groovy configuration, trying fallback 'groovy' instead.");
            }
        }
        list.add(cmd);
        if (StringUtils.isNotBlank((String)this.classPath)) {
            String pathSeparator = isOnUnix ? ":" : ";";
            StringTokenizer stringTokenizer = new StringTokenizer(this.classPath);
            list.add("-cp");
            StringBuilder sb = new StringBuilder();
            sb.append(Util.replaceMacro((String)stringTokenizer.nextToken(), (VariableResolver)vr));
            while (stringTokenizer.hasMoreTokens()) {
                sb.append(pathSeparator);
                sb.append(Util.replaceMacro((String)stringTokenizer.nextToken(), (VariableResolver)vr));
            }
            list.add(sb.toString());
        }
        if (StringUtils.isNotBlank((String)this.properties)) {
            for (Map.Entry entry : Groovy.parseProperties(this.properties).entrySet()) {
                list.add("-D" + String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue()));
            }
        }
        if (StringUtils.isNotBlank((String)this.parameters)) {
            String[] args;
            for (String arg : args = this.parseParams(this.parameters)) {
                list.add(Util.replaceMacro((String)arg, (VariableResolver)vr));
            }
        }
        list.add(script.getRemote());
        if (StringUtils.isNotBlank((String)this.scriptParameters)) {
            String[] params = this.parseParams(this.scriptParameters);
            ParametersAction parametersAction = (ParametersAction)build.getAction(ParametersAction.class);
            for (String param : params) {
                if (parametersAction != null) {
                    param = parametersAction.substitute(build, param);
                }
                param = Util.replaceMacro((String)param, (VariableResolver)vr);
                list.add(param);
            }
        }
        return list;
    }

    private String[] parseParams(String line) {
        CommandLine cmdLine = CommandLine.parse((String)("executable_placeholder " + line));
        String[] parsedArgs = cmdLine.getArguments();
        String[] args = new String[parsedArgs.length];
        if (parsedArgs.length > 0) {
            System.arraycopy(parsedArgs, 0, args, 0, parsedArgs.length);
        }
        return args;
    }

    public ScriptSource getScriptSource() {
        return this.scriptSource;
    }

    @Deprecated
    public String getCommand() {
        return this.command;
    }

    @Deprecated
    public String getScriptFile() {
        return this.scriptFile;
    }

    public String getGroovyName() {
        return this.groovyName;
    }

    @Deprecated
    public BuilderType getType() {
        return this.type;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getScriptParameters() {
        return this.scriptParameters;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getJavaOpts() {
        return this.javaOpts;
    }

    public String getClassPath() {
        return this.classPath;
    }

    private Object readResolve() {
        if (this.type != null) {
            switch (this.type.ordinal()) {
                case 0: {
                    this.scriptSource = new StringScriptSource(this.command);
                    break;
                }
                case 1: {
                    this.scriptSource = new FileScriptSource(this.scriptFile);
                }
            }
        }
        this.type = null;
        this.command = null;
        this.scriptFile = null;
        return this;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractGroovy.AbstractGroovyDescriptor {
        private boolean allowMacro;
        private volatile GroovyInstallation[] installations = new GroovyInstallation[0];
        private volatile List<hudson.plugins.groovy.GroovyInstallation> installations2 = new ArrayList<hudson.plugins.groovy.GroovyInstallation>();

        public DescriptorImpl() {
            super(Groovy.class);
            this.load();
        }

        public Object readResolve() {
            if (this.installations.length > 0) {
                for (GroovyInstallation inst : this.installations) {
                    hudson.plugins.groovy.GroovyInstallation inst2 = new hudson.plugins.groovy.GroovyInstallation(inst.getName(), inst.getHome(), null);
                    this.installations2.add(inst2);
                }
                this.installations = null;
            }
            return this;
        }

        public boolean getAllowMacro() {
            return this.allowMacro;
        }

        public String getDisplayName() {
            return "Execute Groovy script";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public hudson.plugins.groovy.GroovyInstallation[] getInstallations() {
            hudson.plugins.groovy.GroovyInstallation[] installs = new hudson.plugins.groovy.GroovyInstallation[this.installations2.size()];
            return this.installations2.toArray(installs);
        }

        public static hudson.plugins.groovy.GroovyInstallation getGroovy(String groovyName) {
            DescriptorImpl desc;
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins != null && (desc = (DescriptorImpl)jenkins.getDescriptor(Groovy.class)) != null) {
                for (hudson.plugins.groovy.GroovyInstallation i : desc.getInstallations()) {
                    if (groovyName == null || !i.getName().equals(groovyName)) continue;
                    return i;
                }
            }
            return null;
        }

        public void setInstallations(hudson.plugins.groovy.GroovyInstallation ... installations) {
            ArrayList<hudson.plugins.groovy.GroovyInstallation> installations2 = new ArrayList<hudson.plugins.groovy.GroovyInstallation>();
            for (hudson.plugins.groovy.GroovyInstallation install : installations) {
                installations2.add(install);
            }
            this.installations2 = installations2;
            this.save();
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            this.allowMacro = json.getBoolean("allowMacro");
            this.save();
            return true;
        }
    }

    public static enum BuilderType {
        COMMAND,
        FILE;

    }

    public static final class GroovyInstallation
    implements Serializable {
        private final String name;
        private final String home;
        private static final long serialVersionUID = 1L;

        @DataBoundConstructor
        public GroovyInstallation(String name, String home) {
            this.name = name;
            this.home = home;
        }

        public String getHome() {
            return this.home;
        }

        public String getName() {
            return this.name;
        }
    }
}

