/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.groovy.Groovy;
import hudson.plugins.groovy.StringSystemScriptSource;
import hudson.plugins.groovy.SystemGroovy;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension(optional=true)
public class GroovyTokenMacro
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter
    public String script;

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals("GROOVY");
    }

    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins instance is null - Jenkins is shutting down?");
        }
        Groovy.DescriptorImpl decs = (Groovy.DescriptorImpl)jenkins.getDescriptorOrDie(Groovy.class);
        if (decs.getAllowMacro()) {
            SystemGroovy systemGroovy;
            try {
                systemGroovy = new SystemGroovy(new StringSystemScriptSource(new SecureGroovyScript(this.script, true, null)));
            }
            catch (Descriptor.FormException e) {
                throw new RuntimeException(e);
            }
            Object output = systemGroovy.run(context, (BuildListener)listener, null);
            return output != null ? output.toString() : "";
        }
        return this.script;
    }
}

