/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gravatar.cache;

import com.google.common.base.Optional;
import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.jenkinsci.plugins.gravatar.boundary.GravatarImageURLVerifier;
import org.jenkinsci.plugins.gravatar.model.GravatarUrlCreator;
import org.jenkinsci.plugins.gravatar.model.GravatarUser;

class GravatarImageResolutionCacheLoader
extends CacheLoader<GravatarUser, Optional<GravatarUrlCreator>> {
    private static final Logger LOG = Logger.getLogger(GravatarImageResolutionCacheLoader.class.getName());
    private final ListeningExecutorService reloader = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());

    GravatarImageResolutionCacheLoader() {
    }

    public ListenableFuture<Optional<GravatarUrlCreator>> reload(final GravatarUser gravatarUser, Optional<GravatarUrlCreator> oldValue) throws Exception {
        if (oldValue.isPresent()) {
            LOG.finer("Reusing old gravatar result value for " + String.valueOf(gravatarUser) + " because it has been known before.");
            return Futures.immediateFuture(oldValue);
        }
        LOG.fine("Scheduling " + String.valueOf(gravatarUser) + " for reloading");
        ListenableFuture future = this.reloader.submit((Callable)new Callable<Optional<GravatarUrlCreator>>(){
            final /* synthetic */ GravatarImageResolutionCacheLoader this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Optional<GravatarUrlCreator> call() throws Exception {
                return this.this$0.load(gravatarUser);
            }
        });
        return future;
    }

    public Optional<GravatarUrlCreator> load(GravatarUser gravatarUser) throws Exception {
        if (!gravatarUser.emailAddress().isPresent()) {
            LOG.finer("Cannot check for gravatar for user " + String.valueOf(gravatarUser) + " since no e-mail address is known");
            return this.creator();
        }
        if (this.verifier().verify((String)gravatarUser.emailAddress().get())) {
            LOG.fine("Verified gravatar for " + String.valueOf(gravatarUser));
            return this.creatorFor(gravatarUser);
        }
        return this.creator();
    }

    private Optional<GravatarUrlCreator> creator() {
        return Optional.absent();
    }

    private Optional<GravatarUrlCreator> creatorFor(GravatarUser user) {
        return Optional.of((Object)GravatarUrlCreator.of(user));
    }

    private GravatarImageURLVerifier verifier() {
        return new GravatarImageURLVerifier();
    }
}

