/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gravatar.boundary;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import de.bripkens.gravatar.Gravatar;
import hudson.ProxyConfiguration;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.logging.Logger;
import org.jenkinsci.plugins.gravatar.factory.GravatarFactory;

public class GravatarImageURLVerifier {
    private static final Logger LOG = Logger.getLogger(GravatarImageURLVerifier.class.getName());

    public boolean verify(String email) {
        Preconditions.checkNotNull((Object)email);
        String imageURL = this.gravatar().getUrl(email);
        boolean gravatarExistsForEmail = false;
        try {
            URI url = new URI(imageURL);
            HttpClient client = ProxyConfiguration.newHttpClientBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(5L)).build();
            HttpRequest request = ProxyConfiguration.newHttpRequestBuilder((URI)url).timeout(Duration.ofSeconds(5L)).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
            HttpResponse<Void> resp = client.send(request, HttpResponse.BodyHandlers.discarding());
            int gravatarResponseCode = resp.statusCode();
            gravatarExistsForEmail = this.responseCodeIsOK(gravatarResponseCode);
            LOG.finer("Resolved gravatar for " + email + ". Found: " + gravatarExistsForEmail);
        }
        catch (URISyntaxException e) {
            LOG.warning("Gravatar URL is malformed, " + imageURL);
        }
        catch (IOException | InterruptedException e) {
            LOG.fine("Could not connect to the Gravatar URL, " + String.valueOf(e));
        }
        return gravatarExistsForEmail;
    }

    @VisibleForTesting
    protected Gravatar gravatar() {
        return new GravatarFactory().verifyingGravatar();
    }

    private boolean responseCodeIsOK(int gravatarResponseCode) {
        return gravatarResponseCode == 200 || gravatarResponseCode == 304;
    }
}

