/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gravatar.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import hudson.model.User;
import hudson.tasks.Mailer;

public class GravatarUser {
    private final String userId;
    private final Supplier<Optional<String>> mailSupplier = Suppliers.memoize((Supplier)new Supplier<Optional<String>>(){

        public Optional<String> get() {
            Mailer.UserProperty mailProperty = (Mailer.UserProperty)GravatarUser.this.user().getProperty(Mailer.UserProperty.class);
            if (mailProperty == null) {
                return Optional.absent();
            }
            return Optional.fromNullable((Object)Strings.emptyToNull((String)mailProperty.getAddress()));
        }
    });

    public GravatarUser(User user) {
        Preconditions.checkNotNull((Object)user);
        this.userId = user.getId();
    }

    public static GravatarUser gravatarUser(User user) {
        Preconditions.checkNotNull((Object)user);
        return new GravatarUser(user);
    }

    public User user() {
        return User.getById((String)this.userId(), (boolean)false);
    }

    private String userId() {
        return this.userId;
    }

    public Optional<String> emailAddress() {
        return (Optional)this.mailSupplier.get();
    }

    public String toString() {
        return String.format("GravatarUser{userId='%s'}", this.userId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.userId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GravatarUser other = (GravatarUser)obj;
        return Objects.equal((Object)this.userId, (Object)other.userId);
    }
}

