/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gravatar.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import de.bripkens.gravatar.Gravatar;
import org.jenkinsci.plugins.gravatar.factory.GravatarFactory;
import org.jenkinsci.plugins.gravatar.model.GravatarUser;

public class GravatarUrlCreator {
    private final String email;

    private GravatarUrlCreator(String email) {
        this.email = email;
    }

    public static GravatarUrlCreator of(GravatarUser user) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkArgument((boolean)user.emailAddress().isPresent(), (Object)"Only users with e-mail address are supported");
        return new GravatarUrlCreator((String)user.emailAddress().get());
    }

    public String buildUrlForSize(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"Only positive sizes are allowed.");
        return this.gravatar().setSize(size).getUrl(this.email);
    }

    @VisibleForTesting
    Gravatar gravatar() {
        return new GravatarFactory().userGravatar();
    }
}

