/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage.util;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.api.client.auth.oauth2.Credential;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2ScopeRequirement;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import com.google.jenkins.plugins.storage.StorageScopeRequirement;
import com.google.jenkins.plugins.storage.util.Messages;
import hudson.AbortException;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.security.GeneralSecurityException;
import org.acegisecurity.Authentication;

public class CredentialsUtil {
    public static GoogleRobotCredentials getRobotCredentials(ItemGroup itemGroup, ImmutableList<DomainRequirement> domainRequirements, String credentialsId) throws AbortException {
        Preconditions.checkNotNull((Object)itemGroup);
        Preconditions.checkNotNull(domainRequirements);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)credentialsId) ? 1 : 0) != 0);
        GoogleRobotCredentials robotCreds = (GoogleRobotCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(GoogleRobotCredentials.class, (ItemGroup)itemGroup, (Authentication)ACL.SYSTEM, domainRequirements), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (robotCreds == null) {
            throw new AbortException(Messages.CredentialsUtil_FailedToRetrieveCredentials(credentialsId));
        }
        return robotCreds;
    }

    public static Credential getGoogleCredential(GoogleRobotCredentials robotCreds) throws AbortException {
        Credential credential;
        try {
            credential = robotCreds.getGoogleCredential((GoogleOAuth2ScopeRequirement)new StorageScopeRequirement());
        }
        catch (GeneralSecurityException gse) {
            throw new AbortException(Messages.CredentialsUtil_FailedToInitializeHTTPTransport(gse));
        }
        return credential;
    }
}

